/* $Id$ 
 *
 * Mangle/Demangle VHDL names to intermediate code names.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __MANGLE_NAMES_H_INCLUDED
#define __MANGLE_NAMES_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <unistd.h>

/** mangle the VHDL name to an intermediate code name and store it in the
 *  buffer of size sz at dst.
 *  @param name name to mangle
 *  @param dst pointer to buffer
 *  @param sz size of buffer.
 *  @return number of bytes written to dst.
 */
extern int
mangle_name(const char *name, char *dst, size_t sz);

/** demangle the intermediate code name and store it in the buffer
 *  of size sz pointed to by dst.
 *  @param name intermediate code name
 *  @param dst buffer into which the demangeld vhdl name will get stored
 *  @param sz size of dst.
 *  @return number of bytes written to dst.
 */
extern int
demangle_name(const char *name, char *dst, size_t sz);

#ifdef __cplusplus
}; /* extern "C" */
#endif 

#endif /* __MANGLE_NAMES_H_INCLUDED */
