/* $Id: Jbe.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Jbe: jump below or equal (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __JBE_HPP_INCLUDED
#define __JBE_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"
#include "intermediate/container/Label.hpp"

namespace intermediate {

//! jump below or equal
/** This class will jump to target, in case left is smaller or equal than 
 *  right.
 *  
 *  Read operands: left, right, trg.
 *
 *  left operand one comparison operand (integer)
 *  right operand second comparison operand (integer)
 *  trg destination address (label only)
 *
 *  Operation: if (left <= right) /PC/ = trg;
 */
class Jbe : public OpCode {
public:
	//! c'tor
	/** @param l left operand to compare
	 *  @param r right operand to compare
	 *  @param target jump to target, if l<r.
	 */
	Jbe(
		Operand *l,
		Operand *r,
		Label *target
		) :	left(l), right(r), trg(target) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination, if left==right.
	Label *trg;

protected:
	virtual ~Jbe() {
		util::MiscUtil::terminate(this->left);
		util::MiscUtil::terminate(this->right);
		util::MiscUtil::terminate(this->trg);
	}

};

}; /* namespace intermediate */

#endif /* __JB_HPP_INCLUDED */
