// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file finalPubSubTypes.hpp
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastddsgen.
 */


#ifndef FAST_DDS_GENERATED__FINAL_PUBSUBTYPES_HPP
#define FAST_DDS_GENERATED__FINAL_PUBSUBTYPES_HPP

#include <fastdds/dds/core/policy/QosPolicies.hpp>
#include <fastdds/dds/topic/TopicDataType.hpp>
#include <fastdds/rtps/common/InstanceHandle.hpp>
#include <fastdds/rtps/common/SerializedPayload.hpp>
#include <fastdds/utils/md5.hpp>

#include "final.hpp"

#include "helpers/basic_inner_typesPubSubTypes.hpp"

#if !defined(FASTDDS_GEN_API_VER) || (FASTDDS_GEN_API_VER != 3)
#error \
    Generated final is not compatible with current installed Fast DDS. Please, regenerate it with fastddsgen.
#endif  // FASTDDS_GEN_API_VER


#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalShortStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalShortStruct_f
{
    typedef int16_t FinalShortStruct::* type;
    friend constexpr type get(
            FinalShortStruct_f);
};

template struct FinalShortStruct_rob<FinalShortStruct_f, &FinalShortStruct::m_var_short>;

template <typename T, typename Tag>
inline size_t constexpr FinalShortStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalShortStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalShortStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalShortStruct type;

    eProsima_user_DllExport FinalShortStructPubSubType();

    eProsima_user_DllExport ~FinalShortStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalShortStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 2ULL ==
               (detail::FinalShortStruct_offset_of<FinalShortStruct, detail::FinalShortStruct_f>() +
               sizeof(int16_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 2ULL ==
               (detail::FinalShortStruct_offset_of<FinalShortStruct, detail::FinalShortStruct_f>() +
               sizeof(int16_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalUShortStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalUShortStruct_f
{
    typedef uint16_t FinalUShortStruct::* type;
    friend constexpr type get(
            FinalUShortStruct_f);
};

template struct FinalUShortStruct_rob<FinalUShortStruct_f, &FinalUShortStruct::m_var_ushort>;

template <typename T, typename Tag>
inline size_t constexpr FinalUShortStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalUShortStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalUShortStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalUShortStruct type;

    eProsima_user_DllExport FinalUShortStructPubSubType();

    eProsima_user_DllExport ~FinalUShortStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalUShortStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 2ULL ==
               (detail::FinalUShortStruct_offset_of<FinalUShortStruct, detail::FinalUShortStruct_f>() +
               sizeof(uint16_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 2ULL ==
               (detail::FinalUShortStruct_offset_of<FinalUShortStruct, detail::FinalUShortStruct_f>() +
               sizeof(uint16_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalLongStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalLongStruct_f
{
    typedef int32_t FinalLongStruct::* type;
    friend constexpr type get(
            FinalLongStruct_f);
};

template struct FinalLongStruct_rob<FinalLongStruct_f, &FinalLongStruct::m_var_long>;

template <typename T, typename Tag>
inline size_t constexpr FinalLongStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalLongStruct type;

    eProsima_user_DllExport FinalLongStructPubSubType();

    eProsima_user_DllExport ~FinalLongStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalLongStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 4ULL ==
               (detail::FinalLongStruct_offset_of<FinalLongStruct, detail::FinalLongStruct_f>() +
               sizeof(int32_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 4ULL ==
               (detail::FinalLongStruct_offset_of<FinalLongStruct, detail::FinalLongStruct_f>() +
               sizeof(int32_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalULongStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalULongStruct_f
{
    typedef uint32_t FinalULongStruct::* type;
    friend constexpr type get(
            FinalULongStruct_f);
};

template struct FinalULongStruct_rob<FinalULongStruct_f, &FinalULongStruct::m_var_ulong>;

template <typename T, typename Tag>
inline size_t constexpr FinalULongStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalULongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalULongStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalULongStruct type;

    eProsima_user_DllExport FinalULongStructPubSubType();

    eProsima_user_DllExport ~FinalULongStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalULongStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 4ULL ==
               (detail::FinalULongStruct_offset_of<FinalULongStruct, detail::FinalULongStruct_f>() +
               sizeof(uint32_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 4ULL ==
               (detail::FinalULongStruct_offset_of<FinalULongStruct, detail::FinalULongStruct_f>() +
               sizeof(uint32_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalLongLongStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalLongLongStruct_f
{
    typedef int64_t FinalLongLongStruct::* type;
    friend constexpr type get(
            FinalLongLongStruct_f);
};

template struct FinalLongLongStruct_rob<FinalLongLongStruct_f, &FinalLongLongStruct::m_var_longlong>;

template <typename T, typename Tag>
inline size_t constexpr FinalLongLongStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalLongLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongLongStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalLongLongStruct type;

    eProsima_user_DllExport FinalLongLongStructPubSubType();

    eProsima_user_DllExport ~FinalLongLongStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalLongLongStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 8ULL ==
               (detail::FinalLongLongStruct_offset_of<FinalLongLongStruct, detail::FinalLongLongStruct_f>() +
               sizeof(int64_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 8ULL ==
               (detail::FinalLongLongStruct_offset_of<FinalLongLongStruct, detail::FinalLongLongStruct_f>() +
               sizeof(int64_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalULongLongStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalULongLongStruct_f
{
    typedef uint64_t FinalULongLongStruct::* type;
    friend constexpr type get(
            FinalULongLongStruct_f);
};

template struct FinalULongLongStruct_rob<FinalULongLongStruct_f, &FinalULongLongStruct::m_var_ulonglong>;

template <typename T, typename Tag>
inline size_t constexpr FinalULongLongStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalULongLongStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalULongLongStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalULongLongStruct type;

    eProsima_user_DllExport FinalULongLongStructPubSubType();

    eProsima_user_DllExport ~FinalULongLongStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalULongLongStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 8ULL ==
               (detail::FinalULongLongStruct_offset_of<FinalULongLongStruct, detail::FinalULongLongStruct_f>() +
               sizeof(uint64_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 8ULL ==
               (detail::FinalULongLongStruct_offset_of<FinalULongLongStruct, detail::FinalULongLongStruct_f>() +
               sizeof(uint64_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalFloatStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalFloatStruct_f
{
    typedef float FinalFloatStruct::* type;
    friend constexpr type get(
            FinalFloatStruct_f);
};

template struct FinalFloatStruct_rob<FinalFloatStruct_f, &FinalFloatStruct::m_var_float>;

template <typename T, typename Tag>
inline size_t constexpr FinalFloatStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalFloatStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalFloatStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalFloatStruct type;

    eProsima_user_DllExport FinalFloatStructPubSubType();

    eProsima_user_DllExport ~FinalFloatStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalFloatStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 4ULL ==
               (detail::FinalFloatStruct_offset_of<FinalFloatStruct, detail::FinalFloatStruct_f>() +
               sizeof(float));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 4ULL ==
               (detail::FinalFloatStruct_offset_of<FinalFloatStruct, detail::FinalFloatStruct_f>() +
               sizeof(float));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalDoubleStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalDoubleStruct_f
{
    typedef double FinalDoubleStruct::* type;
    friend constexpr type get(
            FinalDoubleStruct_f);
};

template struct FinalDoubleStruct_rob<FinalDoubleStruct_f, &FinalDoubleStruct::m_var_double>;

template <typename T, typename Tag>
inline size_t constexpr FinalDoubleStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalDoubleStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalDoubleStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalDoubleStruct type;

    eProsima_user_DllExport FinalDoubleStructPubSubType();

    eProsima_user_DllExport ~FinalDoubleStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalDoubleStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 8ULL ==
               (detail::FinalDoubleStruct_offset_of<FinalDoubleStruct, detail::FinalDoubleStruct_f>() +
               sizeof(double));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 8ULL ==
               (detail::FinalDoubleStruct_offset_of<FinalDoubleStruct, detail::FinalDoubleStruct_f>() +
               sizeof(double));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalLongDoubleStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalLongDoubleStruct_f
{
    typedef long double FinalLongDoubleStruct::* type;
    friend constexpr type get(
            FinalLongDoubleStruct_f);
};

template struct FinalLongDoubleStruct_rob<FinalLongDoubleStruct_f, &FinalLongDoubleStruct::m_var_longdouble>;

template <typename T, typename Tag>
inline size_t constexpr FinalLongDoubleStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalLongDoubleStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalLongDoubleStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalLongDoubleStruct type;

    eProsima_user_DllExport FinalLongDoubleStructPubSubType();

    eProsima_user_DllExport ~FinalLongDoubleStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalLongDoubleStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 16ULL ==
               (detail::FinalLongDoubleStruct_offset_of<FinalLongDoubleStruct, detail::FinalLongDoubleStruct_f>() +
               sizeof(long double));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 16ULL ==
               (detail::FinalLongDoubleStruct_offset_of<FinalLongDoubleStruct, detail::FinalLongDoubleStruct_f>() +
               sizeof(long double));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalBooleanStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalBooleanStruct_f
{
    typedef bool FinalBooleanStruct::* type;
    friend constexpr type get(
            FinalBooleanStruct_f);
};

template struct FinalBooleanStruct_rob<FinalBooleanStruct_f, &FinalBooleanStruct::m_var_boolean>;

template <typename T, typename Tag>
inline size_t constexpr FinalBooleanStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalBooleanStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalBooleanStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalBooleanStruct type;

    eProsima_user_DllExport FinalBooleanStructPubSubType();

    eProsima_user_DllExport ~FinalBooleanStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalBooleanStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 1ULL ==
               (detail::FinalBooleanStruct_offset_of<FinalBooleanStruct, detail::FinalBooleanStruct_f>() +
               sizeof(bool));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 1ULL ==
               (detail::FinalBooleanStruct_offset_of<FinalBooleanStruct, detail::FinalBooleanStruct_f>() +
               sizeof(bool));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalOctetStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalOctetStruct_f
{
    typedef uint8_t FinalOctetStruct::* type;
    friend constexpr type get(
            FinalOctetStruct_f);
};

template struct FinalOctetStruct_rob<FinalOctetStruct_f, &FinalOctetStruct::m_var_octet>;

template <typename T, typename Tag>
inline size_t constexpr FinalOctetStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalOctetStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalOctetStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalOctetStruct type;

    eProsima_user_DllExport FinalOctetStructPubSubType();

    eProsima_user_DllExport ~FinalOctetStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalOctetStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 1ULL ==
               (detail::FinalOctetStruct_offset_of<FinalOctetStruct, detail::FinalOctetStruct_f>() +
               sizeof(uint8_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 1ULL ==
               (detail::FinalOctetStruct_offset_of<FinalOctetStruct, detail::FinalOctetStruct_f>() +
               sizeof(uint8_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalCharStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalCharStruct_f
{
    typedef char FinalCharStruct::* type;
    friend constexpr type get(
            FinalCharStruct_f);
};

template struct FinalCharStruct_rob<FinalCharStruct_f, &FinalCharStruct::m_var_char8>;

template <typename T, typename Tag>
inline size_t constexpr FinalCharStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalCharStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalCharStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalCharStruct type;

    eProsima_user_DllExport FinalCharStructPubSubType();

    eProsima_user_DllExport ~FinalCharStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalCharStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 1ULL ==
               (detail::FinalCharStruct_offset_of<FinalCharStruct, detail::FinalCharStruct_f>() +
               sizeof(char));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 1ULL ==
               (detail::FinalCharStruct_offset_of<FinalCharStruct, detail::FinalCharStruct_f>() +
               sizeof(char));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalWCharStruct_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalWCharStruct_f
{
    typedef wchar_t FinalWCharStruct::* type;
    friend constexpr type get(
            FinalWCharStruct_f);
};

template struct FinalWCharStruct_rob<FinalWCharStruct_f, &FinalWCharStruct::m_var_char16>;

template <typename T, typename Tag>
inline size_t constexpr FinalWCharStruct_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalWCharStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalWCharStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalWCharStruct type;

    eProsima_user_DllExport FinalWCharStructPubSubType();

    eProsima_user_DllExport ~FinalWCharStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalWCharStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 2ULL ==
               (detail::FinalWCharStruct_offset_of<FinalWCharStruct, detail::FinalWCharStruct_f>() +
               sizeof(wchar_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 2ULL ==
               (detail::FinalWCharStruct_offset_of<FinalWCharStruct, detail::FinalWCharStruct_f>() +
               sizeof(wchar_t));
    }

};

/*!
 * @brief This class represents the TopicDataType of the type FinalUnionStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalUnionStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalUnionStruct type;

    eProsima_user_DllExport FinalUnionStructPubSubType();

    eProsima_user_DllExport ~FinalUnionStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        static_cast<void>(data_representation);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        static_cast<void>(memory);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;

};

/*!
 * @brief This class represents the TopicDataType of the type FinalEmptyStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalEmptyStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalEmptyStruct type;

    eProsima_user_DllExport FinalEmptyStructPubSubType();

    eProsima_user_DllExport ~FinalEmptyStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalEmptyStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return true;
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return true;
    }

};

/*!
 * @brief This class represents the TopicDataType of the type FinalEmptyInheritanceStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalEmptyInheritanceStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalEmptyInheritanceStruct type;

    eProsima_user_DllExport FinalEmptyInheritanceStructPubSubType();

    eProsima_user_DllExport ~FinalEmptyInheritanceStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        static_cast<void>(data_representation);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        static_cast<void>(memory);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;

};

/*!
 * @brief This class represents the TopicDataType of the type FinalInheritanceStruct defined by the user in the IDL file.
 * @ingroup final
 */
class FinalInheritanceStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalInheritanceStruct type;

    eProsima_user_DllExport FinalInheritanceStructPubSubType();

    eProsima_user_DllExport ~FinalInheritanceStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        static_cast<void>(data_representation);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        static_cast<void>(memory);
        return false;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;

};

/*!
 * @brief This class represents the TopicDataType of the type InheritanceEmptyStruct defined by the user in the IDL file.
 * @ingroup final
 */
class InheritanceEmptyStructPubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef InheritanceEmptyStruct type;

    eProsima_user_DllExport InheritanceEmptyStructPubSubType();

    eProsima_user_DllExport ~InheritanceEmptyStructPubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) InheritanceEmptyStruct();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 2ULL ==
               (detail::FinalShortStruct_offset_of<FinalShortStruct, detail::FinalShortStruct_f>() +
               sizeof(int16_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 2ULL ==
               (detail::FinalShortStruct_offset_of<FinalShortStruct, detail::FinalShortStruct_f>() +
               sizeof(int16_t));
    }

};

#ifndef SWIG
namespace detail {

template<typename Tag, typename Tag::type M>
struct FinalExtensibilityInheritance_rob
{
    friend constexpr typename Tag::type get(
            Tag)
    {
        return M;
    }

};

struct FinalExtensibilityInheritance_f
{
    typedef int32_t FinalExtensibilityInheritance::* type;
    friend constexpr type get(
            FinalExtensibilityInheritance_f);
};

template struct FinalExtensibilityInheritance_rob<FinalExtensibilityInheritance_f, &FinalExtensibilityInheritance::m_var_long>;

template <typename T, typename Tag>
inline size_t constexpr FinalExtensibilityInheritance_offset_of()
{
    return ((::size_t) &reinterpret_cast<char const volatile&>((((T*)0)->*get(Tag()))));
}

} // namespace detail
#endif // ifndef SWIG


/*!
 * @brief This class represents the TopicDataType of the type FinalExtensibilityInheritance defined by the user in the IDL file.
 * @ingroup final
 */
class FinalExtensibilityInheritancePubSubType : public eprosima::fastdds::dds::TopicDataType
{
public:

    typedef FinalExtensibilityInheritance type;

    eProsima_user_DllExport FinalExtensibilityInheritancePubSubType();

    eProsima_user_DllExport ~FinalExtensibilityInheritancePubSubType() override;

    eProsima_user_DllExport bool serialize(
            const void* const data,
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool deserialize(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            void* data) override;

    eProsima_user_DllExport uint32_t calculate_serialized_size(
            const void* const data,
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) override;

    eProsima_user_DllExport bool compute_key(
            eprosima::fastdds::rtps::SerializedPayload_t& payload,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport bool compute_key(
            const void* const data,
            eprosima::fastdds::rtps::InstanceHandle_t& ihandle,
            bool force_md5 = false) override;

    eProsima_user_DllExport void* create_data() override;

    eProsima_user_DllExport void delete_data(
            void* data) override;

    //Register TypeObject representation in Fast DDS TypeObjectRegistry
    eProsima_user_DllExport void register_type_object_representation() override;

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED
    eProsima_user_DllExport inline bool is_bounded() const override
    {
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_BOUNDED

#ifdef TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

    eProsima_user_DllExport inline bool is_plain(
            eprosima::fastdds::dds::DataRepresentationId_t data_representation) const override
    {
        if (data_representation == eprosima::fastdds::dds::DataRepresentationId_t::XCDR2_DATA_REPRESENTATION)
        {
            return is_plain_xcdrv2_impl();
        }
        else
        {
            return is_plain_xcdrv1_impl();
        }
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_IS_PLAIN

#ifdef TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE
    eProsima_user_DllExport inline bool construct_sample(
            void* memory) const override
    {
        new (memory) FinalExtensibilityInheritance();
        return true;
    }

#endif  // TOPIC_DATA_TYPE_API_HAS_CONSTRUCT_SAMPLE

private:

    eprosima::fastdds::MD5 md5_;
    unsigned char* key_buffer_;


    static constexpr bool is_plain_xcdrv1_impl()
    {
        return 8ULL ==
               (detail::FinalExtensibilityInheritance_offset_of<FinalExtensibilityInheritance, detail::FinalExtensibilityInheritance_f>() +
               sizeof(int32_t));
    }

    static constexpr bool is_plain_xcdrv2_impl()
    {
        return 8ULL ==
               (detail::FinalExtensibilityInheritance_offset_of<FinalExtensibilityInheritance, detail::FinalExtensibilityInheritance_f>() +
               sizeof(int32_t));
    }

};

#endif // FAST_DDS_GENERATED__FINAL_PUBSUBTYPES_HPP

