/*
 * Copyright 2011, Ben Langmead <langmea@cs.jhu.edu>
 *
 * This file is part of Bowtie 2.
 *
 * Bowtie 2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Bowtie 2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Bowtie 2.  If not, see <http://www.gnu.org/licenses/>.
 */

/// An array that transforms Phred qualities into their maq-like
/// equivalents by dividing by ten and rounding to the nearest 10,
/// but saturating at 3.
unsigned char qualRounds[] = {
	0, 0, 0, 0, 0,                          //   0 -   4
	10, 10, 10, 10, 10, 10, 10, 10, 10, 10, //   5 -  14
	20, 20, 20, 20, 20, 20, 20, 20, 20, 20, //  15 -  24
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  25 -  34
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  35 -  44
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  45 -  54
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  55 -  64
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  65 -  74
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  75 -  84
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  85 -  94
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, //  95 - 104
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 105 - 114
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 115 - 124
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 125 - 134
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 135 - 144
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 145 - 154
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 155 - 164
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 165 - 174
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 175 - 184
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 185 - 194
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 195 - 204
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 205 - 214
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 215 - 224
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 225 - 234
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 235 - 244
	30, 30, 30, 30, 30, 30, 30, 30, 30, 30, // 245 - 254
	30                                      // 255
};

/**
 * Lookup table for converting from Solexa-scaled (log-odds) quality
 * values to Phred-scaled quality values.
 */
unsigned char solToPhred[] = {
	/* -10 */ 0, 1, 1, 1, 1, 1, 1, 2, 2, 3,
	/* 0 */ 3, 4, 4, 5, 5, 6, 7, 8, 9, 10,
	/* 10 */ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* 20 */ 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* 30 */ 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
	/* 40 */ 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
	/* 50 */ 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
	/* 60 */ 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
	/* 70 */ 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
	/* 80 */ 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
	/* 90 */ 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
	/* 100 */ 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
	/* 110 */ 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
	/* 120 */ 120, 121, 122, 123, 124, 125, 126, 127, 128, 129,
	/* 130 */ 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
	/* 140 */ 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
	/* 150 */ 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
	/* 160 */ 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
	/* 170 */ 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
	/* 180 */ 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
	/* 190 */ 190, 191, 192, 193, 194, 195, 196, 197, 198, 199,
	/* 200 */ 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
	/* 210 */ 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
	/* 220 */ 220, 221, 222, 223, 224, 225, 226, 227, 228, 229,
	/* 230 */ 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
	/* 240 */ 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
	/* 250 */ 250, 251, 252, 253, 254, 255
};
