+++
title = "Class SimulationResult"
weight = 80
+++

## Class SimulationResult

The function `simulation.simulate()` returns an object of class `SimulationResult`.

A `SimulationResult` object contains
- simulated radiation intensities,
- coordinate axes, and
- optionally, a title.

#### Plot

For plotting a `SimulationResult` object,
our Python module `ba_plot` provides the function `plot_simulation_result(result)`.

Usage:

```python
from bornagain import ba_plot as bp
bp.parse_args()
simulation = ...
result = simulation.simulate()
bp.plot_simulation_result(result)
```

The function `parse_args()` has been included to process certain command-line arguments.
Let the above code lines be part of `script.py`.

To export the plot to a graphics file `outfile.ext`
(where the extension `ext` can be any of
`eps`, ` jpeg`, ` jpg`, ` pdf`, ` pgf`, ` png`, ` ps`, ` raw`, ` rgba`,
` svg`, ` svgz`, ` tif`, ` tiff`, ` webp`),
invoke the script with
```bash
python3 script.py figfile=outfile.ext
```

To export the simulation result to a data file `outfile.int.gz`,
invoke the script with
```bash
python3 script.py datfile=outfile
```

#### Export to NumPy

A simulation result can be exported to a NumPy array, using
```python
result = simulation.simulate()
arr = result.array()
```
The array can then be saved through the NumPy method
```python
numpy.savetxt("intensity.txt", arr)
```

#### Save in various formats

Alternatively, a simulation result can be directly saved
through the BornAgain Python method
```python
import bornagain as ba
result = simulation.simulate()
ba.IOFactory.writeSimulationResult(result, file_name)
```
where `file_name` must have one of the extensions
- `.txt` - ASCII file with 2D array [nrow][ncol], layout as in NumPy;
- `.int` - BornAgain internal ASCII format;
- `.tif` - 32-bits TIFF file.

To this extension, one may concatenate a second extension to enforce compression:
- `.gz` or
- `.bz2`
