//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/ParticleForm.h
//! @brief     Defines class ParticleForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLEFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLEFORM_H

#include <QGroupBox>

class ParticleItem;
class SampleEditorController;

//! Form for editing a particle
class ParticleForm : public QGroupBox {
    Q_OBJECT
public:
    ParticleForm(QWidget* parent, ParticleItem* particleItem, bool allowAbundance,
                 SampleEditorController* ec, bool allowRemove = true);
    void enableStructureEditing(bool b);

private:
    QAction* m_removeAction = nullptr;
    QAction* m_duplicateAction = nullptr;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_PARTICLEFORM_H
