/////////////////////////////////////////////////////////////////////////
// $Id$
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2011-2019 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA B 02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

#ifndef BX_XOP_FETCHDECODE_TABLES_H
#define BX_XOP_FETCHDECODE_TABLES_H

#if BX_SUPPORT_AVX

// 256 entries for XOP-encoded map 0x8 opcodes
static const Bit64u BxOpcodeGroup_XOP_0x8_01[] = {
  form_opcode(ATTR_NNN1 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLCFILL_BqEq),
  form_opcode(ATTR_NNN1 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLCFILL_BdEd),

  form_opcode(ATTR_NNN2 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLSFILL_BqEq),
  form_opcode(ATTR_NNN2 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLSFILL_BdEd),

  form_opcode(ATTR_NNN3 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLCS_BqEq),
  form_opcode(ATTR_NNN3 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLCS_BdEd),

  form_opcode(ATTR_NNN4 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_TZMSK_BqEq),
  form_opcode(ATTR_NNN4 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_TZMSK_BdEd),

  form_opcode(ATTR_NNN5 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLCIC_BqEq),
  form_opcode(ATTR_NNN5 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLCIC_BdEd),

  form_opcode(ATTR_NNN6 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLSIC_BqEq),
  form_opcode(ATTR_NNN6 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLSIC_BdEd),

  form_opcode(ATTR_NNN7 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_T1MSKC_BqEq),
  last_opcode(ATTR_NNN7 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_T1MSKC_BdEd)
};

static const Bit64u BxOpcodeGroup_XOP_0x8_02[] = {
  form_opcode(ATTR_NNN1 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLCMSK_BqEq),
  form_opcode(ATTR_NNN1 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLCMSK_BdEd),

  form_opcode(ATTR_NNN6 | ATTR_IS64 | ATTR_VEX_L0 | ATTR_VEX_W0, BX_IA_BLCI_BqEq),
  last_opcode(ATTR_NNN6 |             ATTR_VEX_L0 | ATTR_VEX_W1, BX_IA_BLCI_BdEd)
};

static const Bit64u BxOpcodeGroup_XOP_0x8_85[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSSWW_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_86[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSSWD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_87[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSSDQL_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_8E[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSSDD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_8F[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSSDQH_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_95[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSWW_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_96[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSWD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_97[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSDQL_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_9E[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSDD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_9F[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMACSDQH_VdqHdqWdqVIb) };

static const Bit64u BxOpcodeGroup_XOP_0x8_A2[] = {
  form_opcode(ATTR_VEX_W0, BX_IA_VPCMOV_VdqHdqVIbWdq),
  last_opcode(ATTR_VEX_W1, BX_IA_VPCMOV_VdqHdqWdqVIb)
};

static const Bit64u BxOpcodeGroup_XOP_0x8_A3[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPPERM_VdqHdqVIbWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPPERM_VdqHdqWdqVIb)
};

static const Bit64u BxOpcodeGroup_XOP_0x8_A6[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMADCSSWD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_B6[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPMADCSWD_VdqHdqWdqVIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_C0[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTB_VdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_C1[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTW_VdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_C2[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTD_VdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_C3[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTQ_VdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_CC[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMB_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_CD[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMW_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_CE[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMD_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_CF[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMQ_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_EC[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMUB_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_ED[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMUW_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_EE[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMUD_VdqHdqWdqIb) };
static const Bit64u BxOpcodeGroup_XOP_0x8_EF[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPCOMUQ_VdqHdqWdqIb) };

// 256 entries for XOP-encoded map 0x9 opcodes
static const Bit64u BxOpcodeGroup_XOP_0x9_80[] = { last_opcode(ATTR_VEX_W0, BX_IA_VFRCZPS_VpsWps) };
static const Bit64u BxOpcodeGroup_XOP_0x9_81[] = { last_opcode(ATTR_VEX_W0, BX_IA_VFRCZPD_VpdWpd) };
static const Bit64u BxOpcodeGroup_XOP_0x9_82[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VFRCZSS_VssWss) };
static const Bit64u BxOpcodeGroup_XOP_0x9_83[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VFRCZSD_VsdWsd) };

static const Bit64u BxOpcodeGroup_XOP_0x9_88[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHAB_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHAB_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_89[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHAW_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHAW_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_8A[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHAD_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHAD_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_8B[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHAQ_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHAQ_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_90[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTB_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPROTB_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_91[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTW_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPROTW_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_92[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTD_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPROTD_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_93[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPROTQ_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPROTQ_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_94[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHLB_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHLB_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_95[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHLW_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHLW_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_96[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHLD_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHLD_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_97[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPSHLQ_VdqHdqWdq),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0, BX_IA_VPSHLQ_VdqWdqHdq)
};

static const Bit64u BxOpcodeGroup_XOP_0x9_C1[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDBW_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_C2[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDBD_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_C3[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDBQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_C6[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDWD_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_C7[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDWQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_CB[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDDQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_D1[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUBW_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_D2[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUBD_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_D3[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUBQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_D6[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUWD_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_D7[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUWQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_DB[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHADDUDQ_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_E1[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHSUBBW_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_E2[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHSUBWD_VdqWdq) };
static const Bit64u BxOpcodeGroup_XOP_0x9_E3[] = { last_opcode(ATTR_VEX_W0 | ATTR_VEX_L0, BX_IA_VPHSUBDQ_VdqWdq) };

// 256 entries for XOP-encoded map 0xA opcodes
static const Bit64u BxOpcodeGroup_XOP_0xA_10[] = {
  form_opcode(ATTR_VEX_W0 | ATTR_VEX_L0,             BX_IA_BEXTR_GdEdId),
  last_opcode(ATTR_VEX_W1 | ATTR_VEX_L0 | ATTR_IS64, BX_IA_BEXTR_GqEqId)
};

static const Bit64u *BxOpcodeTableXOP[256*3] = {
  // 256 entries for XOP-encoded map 0x8 opcodes
  /* 00  */ ( BxOpcodeGroup_ERR ),
  /* 01  */ ( BxOpcodeGroup_XOP_0x8_01 ),
  /* 02  */ ( BxOpcodeGroup_XOP_0x8_02 ),
  /* 03  */ ( BxOpcodeGroup_ERR ),
  /* 04  */ ( BxOpcodeGroup_ERR ),
  /* 05  */ ( BxOpcodeGroup_ERR ),
  /* 06  */ ( BxOpcodeGroup_ERR ),
  /* 07  */ ( BxOpcodeGroup_ERR ),
  /* 08  */ ( BxOpcodeGroup_ERR ),
  /* 09  */ ( BxOpcodeGroup_ERR ),
  /* 0A  */ ( BxOpcodeGroup_ERR ),
  /* 0B  */ ( BxOpcodeGroup_ERR ),
  /* 0C  */ ( BxOpcodeGroup_ERR ),
  /* 0D  */ ( BxOpcodeGroup_ERR ),
  /* 0E  */ ( BxOpcodeGroup_ERR ),
  /* 0F  */ ( BxOpcodeGroup_ERR ),
  /* 10  */ ( BxOpcodeGroup_ERR ),
  /* 11  */ ( BxOpcodeGroup_ERR ),
  /* 12  */ ( BxOpcodeGroup_ERR ),
  /* 13  */ ( BxOpcodeGroup_ERR ),
  /* 14  */ ( BxOpcodeGroup_ERR ),
  /* 15  */ ( BxOpcodeGroup_ERR ),
  /* 16  */ ( BxOpcodeGroup_ERR ),
  /* 17  */ ( BxOpcodeGroup_ERR ),
  /* 18  */ ( BxOpcodeGroup_ERR ),
  /* 19  */ ( BxOpcodeGroup_ERR ),
  /* 1A  */ ( BxOpcodeGroup_ERR ),
  /* 1B  */ ( BxOpcodeGroup_ERR ),
  /* 1C  */ ( BxOpcodeGroup_ERR ),
  /* 1D  */ ( BxOpcodeGroup_ERR ),
  /* 1E  */ ( BxOpcodeGroup_ERR ),
  /* 1F  */ ( BxOpcodeGroup_ERR ),
  /* 20  */ ( BxOpcodeGroup_ERR ),
  /* 21  */ ( BxOpcodeGroup_ERR ),
  /* 22  */ ( BxOpcodeGroup_ERR ),
  /* 23  */ ( BxOpcodeGroup_ERR ),
  /* 24  */ ( BxOpcodeGroup_ERR ),
  /* 25  */ ( BxOpcodeGroup_ERR ),
  /* 26  */ ( BxOpcodeGroup_ERR ),
  /* 27  */ ( BxOpcodeGroup_ERR ),
  /* 28  */ ( BxOpcodeGroup_ERR ),
  /* 29  */ ( BxOpcodeGroup_ERR ),
  /* 2A  */ ( BxOpcodeGroup_ERR ),
  /* 2B  */ ( BxOpcodeGroup_ERR ),
  /* 2C  */ ( BxOpcodeGroup_ERR ),
  /* 2D  */ ( BxOpcodeGroup_ERR ),
  /* 2E  */ ( BxOpcodeGroup_ERR ),
  /* 2F  */ ( BxOpcodeGroup_ERR ),
  /* 30  */ ( BxOpcodeGroup_ERR ),
  /* 31  */ ( BxOpcodeGroup_ERR ),
  /* 32  */ ( BxOpcodeGroup_ERR ),
  /* 33  */ ( BxOpcodeGroup_ERR ),
  /* 34  */ ( BxOpcodeGroup_ERR ),
  /* 35  */ ( BxOpcodeGroup_ERR ),
  /* 36  */ ( BxOpcodeGroup_ERR ),
  /* 37  */ ( BxOpcodeGroup_ERR ),
  /* 38  */ ( BxOpcodeGroup_ERR ),
  /* 39  */ ( BxOpcodeGroup_ERR ),
  /* 3A  */ ( BxOpcodeGroup_ERR ),
  /* 3B  */ ( BxOpcodeGroup_ERR ),
  /* 3C  */ ( BxOpcodeGroup_ERR ),
  /* 3D  */ ( BxOpcodeGroup_ERR ),
  /* 3E  */ ( BxOpcodeGroup_ERR ),
  /* 3F  */ ( BxOpcodeGroup_ERR ),
  /* 40  */ ( BxOpcodeGroup_ERR ),
  /* 41  */ ( BxOpcodeGroup_ERR ),
  /* 42  */ ( BxOpcodeGroup_ERR ),
  /* 43  */ ( BxOpcodeGroup_ERR ),
  /* 44  */ ( BxOpcodeGroup_ERR ),
  /* 45  */ ( BxOpcodeGroup_ERR ),
  /* 46  */ ( BxOpcodeGroup_ERR ),
  /* 47  */ ( BxOpcodeGroup_ERR ),
  /* 48  */ ( BxOpcodeGroup_ERR ),
  /* 49  */ ( BxOpcodeGroup_ERR ),
  /* 4A  */ ( BxOpcodeGroup_ERR ),
  /* 4B  */ ( BxOpcodeGroup_ERR ),
  /* 4C  */ ( BxOpcodeGroup_ERR ),
  /* 4D  */ ( BxOpcodeGroup_ERR ),
  /* 4E  */ ( BxOpcodeGroup_ERR ),
  /* 4F  */ ( BxOpcodeGroup_ERR ),
  /* 50  */ ( BxOpcodeGroup_ERR ),
  /* 51  */ ( BxOpcodeGroup_ERR ),
  /* 52  */ ( BxOpcodeGroup_ERR ),
  /* 53  */ ( BxOpcodeGroup_ERR ),
  /* 54  */ ( BxOpcodeGroup_ERR ),
  /* 55  */ ( BxOpcodeGroup_ERR ),
  /* 56  */ ( BxOpcodeGroup_ERR ),
  /* 57  */ ( BxOpcodeGroup_ERR ),
  /* 58  */ ( BxOpcodeGroup_ERR ),
  /* 59  */ ( BxOpcodeGroup_ERR ),
  /* 5A  */ ( BxOpcodeGroup_ERR ),
  /* 5B  */ ( BxOpcodeGroup_ERR ),
  /* 5C  */ ( BxOpcodeGroup_ERR ),
  /* 5D  */ ( BxOpcodeGroup_ERR ),
  /* 5E  */ ( BxOpcodeGroup_ERR ),
  /* 5F  */ ( BxOpcodeGroup_ERR ),
  /* 60  */ ( BxOpcodeGroup_ERR ),
  /* 61  */ ( BxOpcodeGroup_ERR ),
  /* 62  */ ( BxOpcodeGroup_ERR ),
  /* 63  */ ( BxOpcodeGroup_ERR ),
  /* 64  */ ( BxOpcodeGroup_ERR ),
  /* 65  */ ( BxOpcodeGroup_ERR ),
  /* 66  */ ( BxOpcodeGroup_ERR ),
  /* 67  */ ( BxOpcodeGroup_ERR ),
  /* 68  */ ( BxOpcodeGroup_ERR ),
  /* 69  */ ( BxOpcodeGroup_ERR ),
  /* 6A  */ ( BxOpcodeGroup_ERR ),
  /* 6B  */ ( BxOpcodeGroup_ERR ),
  /* 6C  */ ( BxOpcodeGroup_ERR ),
  /* 6D  */ ( BxOpcodeGroup_ERR ),
  /* 6E  */ ( BxOpcodeGroup_ERR ),
  /* 6F  */ ( BxOpcodeGroup_ERR ),
  /* 70  */ ( BxOpcodeGroup_ERR ),
  /* 71  */ ( BxOpcodeGroup_ERR ),
  /* 72  */ ( BxOpcodeGroup_ERR ),
  /* 73  */ ( BxOpcodeGroup_ERR ),
  /* 74  */ ( BxOpcodeGroup_ERR ),
  /* 75  */ ( BxOpcodeGroup_ERR ),
  /* 76  */ ( BxOpcodeGroup_ERR ),
  /* 77  */ ( BxOpcodeGroup_ERR ),
  /* 78  */ ( BxOpcodeGroup_ERR ),
  /* 79  */ ( BxOpcodeGroup_ERR ),
  /* 7A  */ ( BxOpcodeGroup_ERR ),
  /* 7B  */ ( BxOpcodeGroup_ERR ),
  /* 7C  */ ( BxOpcodeGroup_ERR ),
  /* 7D  */ ( BxOpcodeGroup_ERR ),
  /* 7E  */ ( BxOpcodeGroup_ERR ),
  /* 7F  */ ( BxOpcodeGroup_ERR ),
  /* 80  */ ( BxOpcodeGroup_ERR ),
  /* 81  */ ( BxOpcodeGroup_ERR ),
  /* 82  */ ( BxOpcodeGroup_ERR ),
  /* 83  */ ( BxOpcodeGroup_ERR ),
  /* 84  */ ( BxOpcodeGroup_ERR ),
  /* 85  */ ( BxOpcodeGroup_XOP_0x8_85 ),
  /* 86  */ ( BxOpcodeGroup_XOP_0x8_86 ),
  /* 87  */ ( BxOpcodeGroup_XOP_0x8_87 ),
  /* 88  */ ( BxOpcodeGroup_ERR ),
  /* 89  */ ( BxOpcodeGroup_ERR ),
  /* 8A  */ ( BxOpcodeGroup_ERR ),
  /* 8B  */ ( BxOpcodeGroup_ERR ),
  /* 8C  */ ( BxOpcodeGroup_ERR ),
  /* 8D  */ ( BxOpcodeGroup_ERR ),
  /* 8E  */ ( BxOpcodeGroup_XOP_0x8_8E ),
  /* 8F  */ ( BxOpcodeGroup_XOP_0x8_8F ),
  /* 90  */ ( BxOpcodeGroup_ERR ),
  /* 91  */ ( BxOpcodeGroup_ERR ),
  /* 92  */ ( BxOpcodeGroup_ERR ),
  /* 93  */ ( BxOpcodeGroup_ERR ),
  /* 94  */ ( BxOpcodeGroup_ERR ),
  /* 95  */ ( BxOpcodeGroup_XOP_0x8_95 ),
  /* 96  */ ( BxOpcodeGroup_XOP_0x8_96 ),
  /* 97  */ ( BxOpcodeGroup_XOP_0x8_97 ),
  /* 98  */ ( BxOpcodeGroup_ERR ),
  /* 99  */ ( BxOpcodeGroup_ERR ),
  /* 9A  */ ( BxOpcodeGroup_ERR ),
  /* 9B  */ ( BxOpcodeGroup_ERR ),
  /* 9C  */ ( BxOpcodeGroup_ERR ),
  /* 9D  */ ( BxOpcodeGroup_ERR ),
  /* 9E  */ ( BxOpcodeGroup_XOP_0x8_9E ),
  /* 9F  */ ( BxOpcodeGroup_XOP_0x8_9F ),
  /* A0  */ ( BxOpcodeGroup_ERR ),
  /* A1  */ ( BxOpcodeGroup_ERR ),
  /* A2  */ ( BxOpcodeGroup_XOP_0x8_A2 ),
  /* A3  */ ( BxOpcodeGroup_XOP_0x8_A3 ),
  /* A4  */ ( BxOpcodeGroup_ERR ),
  /* A5  */ ( BxOpcodeGroup_ERR ),
  /* A6  */ ( BxOpcodeGroup_XOP_0x8_A6 ),
  /* A7  */ ( BxOpcodeGroup_ERR ),
  /* A8  */ ( BxOpcodeGroup_ERR ),
  /* A9  */ ( BxOpcodeGroup_ERR ),
  /* AA  */ ( BxOpcodeGroup_ERR ),
  /* AB  */ ( BxOpcodeGroup_ERR ),
  /* AC  */ ( BxOpcodeGroup_ERR ),
  /* AD  */ ( BxOpcodeGroup_ERR ),
  /* AE  */ ( BxOpcodeGroup_ERR ),
  /* AF  */ ( BxOpcodeGroup_ERR ),
  /* B0  */ ( BxOpcodeGroup_ERR ),
  /* B1  */ ( BxOpcodeGroup_ERR ),
  /* B2  */ ( BxOpcodeGroup_ERR ),
  /* B3  */ ( BxOpcodeGroup_ERR ),
  /* B4  */ ( BxOpcodeGroup_ERR ),
  /* B5  */ ( BxOpcodeGroup_ERR ),
  /* B6  */ ( BxOpcodeGroup_XOP_0x8_B6 ),
  /* B7  */ ( BxOpcodeGroup_ERR ),
  /* B8  */ ( BxOpcodeGroup_ERR ),
  /* B9  */ ( BxOpcodeGroup_ERR ),
  /* BA  */ ( BxOpcodeGroup_ERR ),
  /* BB  */ ( BxOpcodeGroup_ERR ),
  /* BC  */ ( BxOpcodeGroup_ERR ),
  /* BD  */ ( BxOpcodeGroup_ERR ),
  /* BE  */ ( BxOpcodeGroup_ERR ),
  /* BF  */ ( BxOpcodeGroup_ERR ),
  /* C0  */ ( BxOpcodeGroup_XOP_0x8_C0 ),
  /* C1  */ ( BxOpcodeGroup_XOP_0x8_C1 ),
  /* C2  */ ( BxOpcodeGroup_XOP_0x8_C2 ),
  /* C3  */ ( BxOpcodeGroup_XOP_0x8_C3 ),
  /* C4  */ ( BxOpcodeGroup_ERR ),
  /* C5  */ ( BxOpcodeGroup_ERR ),
  /* C6  */ ( BxOpcodeGroup_ERR ),
  /* C7  */ ( BxOpcodeGroup_ERR ),
  /* C8  */ ( BxOpcodeGroup_ERR ),
  /* C9  */ ( BxOpcodeGroup_ERR ),
  /* CA  */ ( BxOpcodeGroup_ERR ),
  /* CB  */ ( BxOpcodeGroup_ERR ),
  /* CC  */ ( BxOpcodeGroup_XOP_0x8_CC ),
  /* CD  */ ( BxOpcodeGroup_XOP_0x8_CD ),
  /* CE  */ ( BxOpcodeGroup_XOP_0x8_CE ),
  /* CF  */ ( BxOpcodeGroup_XOP_0x8_CF ),
  /* D0  */ ( BxOpcodeGroup_ERR ),
  /* D1  */ ( BxOpcodeGroup_ERR ),
  /* D2  */ ( BxOpcodeGroup_ERR ),
  /* D3  */ ( BxOpcodeGroup_ERR ),
  /* D4  */ ( BxOpcodeGroup_ERR ),
  /* D5  */ ( BxOpcodeGroup_ERR ),
  /* D6  */ ( BxOpcodeGroup_ERR ),
  /* D7  */ ( BxOpcodeGroup_ERR ),
  /* D8  */ ( BxOpcodeGroup_ERR ),
  /* D9  */ ( BxOpcodeGroup_ERR ),
  /* DA  */ ( BxOpcodeGroup_ERR ),
  /* DB  */ ( BxOpcodeGroup_ERR ),
  /* DC  */ ( BxOpcodeGroup_ERR ),
  /* DD  */ ( BxOpcodeGroup_ERR ),
  /* DE  */ ( BxOpcodeGroup_ERR ),
  /* DF  */ ( BxOpcodeGroup_ERR ),
  /* E0  */ ( BxOpcodeGroup_ERR ),
  /* E1  */ ( BxOpcodeGroup_ERR ),
  /* E2  */ ( BxOpcodeGroup_ERR ),
  /* E3  */ ( BxOpcodeGroup_ERR ),
  /* E4  */ ( BxOpcodeGroup_ERR ),
  /* E5  */ ( BxOpcodeGroup_ERR ),
  /* E6  */ ( BxOpcodeGroup_ERR ),
  /* E7  */ ( BxOpcodeGroup_ERR ),
  /* E8  */ ( BxOpcodeGroup_ERR ),
  /* E9  */ ( BxOpcodeGroup_ERR ),
  /* EA  */ ( BxOpcodeGroup_ERR ),
  /* EB  */ ( BxOpcodeGroup_ERR ),
  /* EC  */ ( BxOpcodeGroup_XOP_0x8_EC ),
  /* ED  */ ( BxOpcodeGroup_XOP_0x8_ED ),
  /* EE  */ ( BxOpcodeGroup_XOP_0x8_EE ),
  /* EF  */ ( BxOpcodeGroup_XOP_0x8_EF ),
  /* F0  */ ( BxOpcodeGroup_ERR ),
  /* F1  */ ( BxOpcodeGroup_ERR ),
  /* F2  */ ( BxOpcodeGroup_ERR ),
  /* F3  */ ( BxOpcodeGroup_ERR ),
  /* F4  */ ( BxOpcodeGroup_ERR ),
  /* F5  */ ( BxOpcodeGroup_ERR ),
  /* F6  */ ( BxOpcodeGroup_ERR ),
  /* F7  */ ( BxOpcodeGroup_ERR ),
  /* F8  */ ( BxOpcodeGroup_ERR ),
  /* F9  */ ( BxOpcodeGroup_ERR ),
  /* FA  */ ( BxOpcodeGroup_ERR ),
  /* FB  */ ( BxOpcodeGroup_ERR ),
  /* FC  */ ( BxOpcodeGroup_ERR ),
  /* FD  */ ( BxOpcodeGroup_ERR ),
  /* FE  */ ( BxOpcodeGroup_ERR ),
  /* FF  */ ( BxOpcodeGroup_ERR ),

  // 256 entries for XOP-encoded map 0x9 opcodes
  /* 00  */ ( BxOpcodeGroup_ERR ),
  /* 01  */ ( BxOpcodeGroup_ERR ),
  /* 02  */ ( BxOpcodeGroup_ERR ),
  /* 03  */ ( BxOpcodeGroup_ERR ),
  /* 04  */ ( BxOpcodeGroup_ERR ),
  /* 05  */ ( BxOpcodeGroup_ERR ),
  /* 06  */ ( BxOpcodeGroup_ERR ),
  /* 07  */ ( BxOpcodeGroup_ERR ),
  /* 08  */ ( BxOpcodeGroup_ERR ),
  /* 09  */ ( BxOpcodeGroup_ERR ),
  /* 0A  */ ( BxOpcodeGroup_ERR ),
  /* 0B  */ ( BxOpcodeGroup_ERR ),
  /* 0C  */ ( BxOpcodeGroup_ERR ),
  /* 0D  */ ( BxOpcodeGroup_ERR ),
  /* 0E  */ ( BxOpcodeGroup_ERR ),
  /* 0F  */ ( BxOpcodeGroup_ERR ),
  /* 10  */ ( BxOpcodeGroup_ERR ),
  /* 11  */ ( BxOpcodeGroup_ERR ),
  /* 12  */ ( BxOpcodeGroup_ERR ),
  /* 13  */ ( BxOpcodeGroup_ERR ),
  /* 14  */ ( BxOpcodeGroup_ERR ),
  /* 15  */ ( BxOpcodeGroup_ERR ),
  /* 16  */ ( BxOpcodeGroup_ERR ),
  /* 17  */ ( BxOpcodeGroup_ERR ),
  /* 18  */ ( BxOpcodeGroup_ERR ),
  /* 19  */ ( BxOpcodeGroup_ERR ),
  /* 1A  */ ( BxOpcodeGroup_ERR ),
  /* 1B  */ ( BxOpcodeGroup_ERR ),
  /* 1C  */ ( BxOpcodeGroup_ERR ),
  /* 1D  */ ( BxOpcodeGroup_ERR ),
  /* 1E  */ ( BxOpcodeGroup_ERR ),
  /* 1F  */ ( BxOpcodeGroup_ERR ),
  /* 20  */ ( BxOpcodeGroup_ERR ),
  /* 21  */ ( BxOpcodeGroup_ERR ),
  /* 22  */ ( BxOpcodeGroup_ERR ),
  /* 23  */ ( BxOpcodeGroup_ERR ),
  /* 24  */ ( BxOpcodeGroup_ERR ),
  /* 25  */ ( BxOpcodeGroup_ERR ),
  /* 26  */ ( BxOpcodeGroup_ERR ),
  /* 27  */ ( BxOpcodeGroup_ERR ),
  /* 28  */ ( BxOpcodeGroup_ERR ),
  /* 29  */ ( BxOpcodeGroup_ERR ),
  /* 2A  */ ( BxOpcodeGroup_ERR ),
  /* 2B  */ ( BxOpcodeGroup_ERR ),
  /* 2C  */ ( BxOpcodeGroup_ERR ),
  /* 2D  */ ( BxOpcodeGroup_ERR ),
  /* 2E  */ ( BxOpcodeGroup_ERR ),
  /* 2F  */ ( BxOpcodeGroup_ERR ),
  /* 30  */ ( BxOpcodeGroup_ERR ),
  /* 31  */ ( BxOpcodeGroup_ERR ),
  /* 32  */ ( BxOpcodeGroup_ERR ),
  /* 33  */ ( BxOpcodeGroup_ERR ),
  /* 34  */ ( BxOpcodeGroup_ERR ),
  /* 35  */ ( BxOpcodeGroup_ERR ),
  /* 36  */ ( BxOpcodeGroup_ERR ),
  /* 37  */ ( BxOpcodeGroup_ERR ),
  /* 38  */ ( BxOpcodeGroup_ERR ),
  /* 39  */ ( BxOpcodeGroup_ERR ),
  /* 3A  */ ( BxOpcodeGroup_ERR ),
  /* 3B  */ ( BxOpcodeGroup_ERR ),
  /* 3C  */ ( BxOpcodeGroup_ERR ),
  /* 3D  */ ( BxOpcodeGroup_ERR ),
  /* 3E  */ ( BxOpcodeGroup_ERR ),
  /* 3F  */ ( BxOpcodeGroup_ERR ),
  /* 40  */ ( BxOpcodeGroup_ERR ),
  /* 41  */ ( BxOpcodeGroup_ERR ),
  /* 42  */ ( BxOpcodeGroup_ERR ),
  /* 43  */ ( BxOpcodeGroup_ERR ),
  /* 44  */ ( BxOpcodeGroup_ERR ),
  /* 45  */ ( BxOpcodeGroup_ERR ),
  /* 46  */ ( BxOpcodeGroup_ERR ),
  /* 47  */ ( BxOpcodeGroup_ERR ),
  /* 48  */ ( BxOpcodeGroup_ERR ),
  /* 49  */ ( BxOpcodeGroup_ERR ),
  /* 4A  */ ( BxOpcodeGroup_ERR ),
  /* 4B  */ ( BxOpcodeGroup_ERR ),
  /* 4C  */ ( BxOpcodeGroup_ERR ),
  /* 4D  */ ( BxOpcodeGroup_ERR ),
  /* 4E  */ ( BxOpcodeGroup_ERR ),
  /* 4F  */ ( BxOpcodeGroup_ERR ),
  /* 50  */ ( BxOpcodeGroup_ERR ),
  /* 51  */ ( BxOpcodeGroup_ERR ),
  /* 52  */ ( BxOpcodeGroup_ERR ),
  /* 53  */ ( BxOpcodeGroup_ERR ),
  /* 54  */ ( BxOpcodeGroup_ERR ),
  /* 55  */ ( BxOpcodeGroup_ERR ),
  /* 56  */ ( BxOpcodeGroup_ERR ),
  /* 57  */ ( BxOpcodeGroup_ERR ),
  /* 58  */ ( BxOpcodeGroup_ERR ),
  /* 59  */ ( BxOpcodeGroup_ERR ),
  /* 5A  */ ( BxOpcodeGroup_ERR ),
  /* 5B  */ ( BxOpcodeGroup_ERR ),
  /* 5C  */ ( BxOpcodeGroup_ERR ),
  /* 5D  */ ( BxOpcodeGroup_ERR ),
  /* 5E  */ ( BxOpcodeGroup_ERR ),
  /* 5F  */ ( BxOpcodeGroup_ERR ),
  /* 60  */ ( BxOpcodeGroup_ERR ),
  /* 61  */ ( BxOpcodeGroup_ERR ),
  /* 62  */ ( BxOpcodeGroup_ERR ),
  /* 63  */ ( BxOpcodeGroup_ERR ),
  /* 64  */ ( BxOpcodeGroup_ERR ),
  /* 65  */ ( BxOpcodeGroup_ERR ),
  /* 66  */ ( BxOpcodeGroup_ERR ),
  /* 67  */ ( BxOpcodeGroup_ERR ),
  /* 68  */ ( BxOpcodeGroup_ERR ),
  /* 69  */ ( BxOpcodeGroup_ERR ),
  /* 6A  */ ( BxOpcodeGroup_ERR ),
  /* 6B  */ ( BxOpcodeGroup_ERR ),
  /* 6C  */ ( BxOpcodeGroup_ERR ),
  /* 6D  */ ( BxOpcodeGroup_ERR ),
  /* 6E  */ ( BxOpcodeGroup_ERR ),
  /* 6F  */ ( BxOpcodeGroup_ERR ),
  /* 70  */ ( BxOpcodeGroup_ERR ),
  /* 71  */ ( BxOpcodeGroup_ERR ),
  /* 72  */ ( BxOpcodeGroup_ERR ),
  /* 73  */ ( BxOpcodeGroup_ERR ),
  /* 74  */ ( BxOpcodeGroup_ERR ),
  /* 75  */ ( BxOpcodeGroup_ERR ),
  /* 76  */ ( BxOpcodeGroup_ERR ),
  /* 77  */ ( BxOpcodeGroup_ERR ),
  /* 78  */ ( BxOpcodeGroup_ERR ),
  /* 79  */ ( BxOpcodeGroup_ERR ),
  /* 7A  */ ( BxOpcodeGroup_ERR ),
  /* 7B  */ ( BxOpcodeGroup_ERR ),
  /* 7C  */ ( BxOpcodeGroup_ERR ),
  /* 7D  */ ( BxOpcodeGroup_ERR ),
  /* 7E  */ ( BxOpcodeGroup_ERR ),
  /* 7F  */ ( BxOpcodeGroup_ERR ),
  /* 80  */ ( BxOpcodeGroup_XOP_0x9_80 ),
  /* 81  */ ( BxOpcodeGroup_XOP_0x9_81 ),
  /* 82  */ ( BxOpcodeGroup_XOP_0x9_82 ),
  /* 83  */ ( BxOpcodeGroup_XOP_0x9_83 ),
  /* 84  */ ( BxOpcodeGroup_ERR ),
  /* 85  */ ( BxOpcodeGroup_ERR ),
  /* 86  */ ( BxOpcodeGroup_ERR ),
  /* 87  */ ( BxOpcodeGroup_ERR ),
  /* 88  */ ( BxOpcodeGroup_XOP_0x9_88 ),
  /* 89  */ ( BxOpcodeGroup_XOP_0x9_89 ),
  /* 8A  */ ( BxOpcodeGroup_XOP_0x9_8A ),
  /* 8B  */ ( BxOpcodeGroup_XOP_0x9_8B ),
  /* 8C  */ ( BxOpcodeGroup_ERR ),
  /* 8D  */ ( BxOpcodeGroup_ERR ),
  /* 8E  */ ( BxOpcodeGroup_ERR ),
  /* 8F  */ ( BxOpcodeGroup_ERR ),
  /* 90  */ ( BxOpcodeGroup_XOP_0x9_90 ),
  /* 91  */ ( BxOpcodeGroup_XOP_0x9_91 ),
  /* 92  */ ( BxOpcodeGroup_XOP_0x9_92 ),
  /* 93  */ ( BxOpcodeGroup_XOP_0x9_93 ),
  /* 94  */ ( BxOpcodeGroup_XOP_0x9_94 ),
  /* 95  */ ( BxOpcodeGroup_XOP_0x9_95 ),
  /* 96  */ ( BxOpcodeGroup_XOP_0x9_96 ),
  /* 97  */ ( BxOpcodeGroup_XOP_0x9_97 ),
  /* 98  */ ( BxOpcodeGroup_ERR ),
  /* 99  */ ( BxOpcodeGroup_ERR ),
  /* 9A  */ ( BxOpcodeGroup_ERR ),
  /* 9B  */ ( BxOpcodeGroup_ERR ),
  /* 9C  */ ( BxOpcodeGroup_ERR ),
  /* 9D  */ ( BxOpcodeGroup_ERR ),
  /* 9E  */ ( BxOpcodeGroup_ERR ),
  /* 9F  */ ( BxOpcodeGroup_ERR ),
  /* A0  */ ( BxOpcodeGroup_ERR ),
  /* A1  */ ( BxOpcodeGroup_ERR ),
  /* A2  */ ( BxOpcodeGroup_ERR ),
  /* A3  */ ( BxOpcodeGroup_ERR ),
  /* A4  */ ( BxOpcodeGroup_ERR ),
  /* A5  */ ( BxOpcodeGroup_ERR ),
  /* A6  */ ( BxOpcodeGroup_ERR ),
  /* A7  */ ( BxOpcodeGroup_ERR ),
  /* A8  */ ( BxOpcodeGroup_ERR ),
  /* A9  */ ( BxOpcodeGroup_ERR ),
  /* AA  */ ( BxOpcodeGroup_ERR ),
  /* AB  */ ( BxOpcodeGroup_ERR ),
  /* AC  */ ( BxOpcodeGroup_ERR ),
  /* AD  */ ( BxOpcodeGroup_ERR ),
  /* AE  */ ( BxOpcodeGroup_ERR ),
  /* AF  */ ( BxOpcodeGroup_ERR ),
  /* B0  */ ( BxOpcodeGroup_ERR ),
  /* B1  */ ( BxOpcodeGroup_ERR ),
  /* B2  */ ( BxOpcodeGroup_ERR ),
  /* B3  */ ( BxOpcodeGroup_ERR ),
  /* B4  */ ( BxOpcodeGroup_ERR ),
  /* B5  */ ( BxOpcodeGroup_ERR ),
  /* B6  */ ( BxOpcodeGroup_ERR ),
  /* B7  */ ( BxOpcodeGroup_ERR ),
  /* B8  */ ( BxOpcodeGroup_ERR ),
  /* B9  */ ( BxOpcodeGroup_ERR ),
  /* BA  */ ( BxOpcodeGroup_ERR ),
  /* BB  */ ( BxOpcodeGroup_ERR ),
  /* BC  */ ( BxOpcodeGroup_ERR ),
  /* BD  */ ( BxOpcodeGroup_ERR ),
  /* BE  */ ( BxOpcodeGroup_ERR ),
  /* BF  */ ( BxOpcodeGroup_ERR ),
  /* C0  */ ( BxOpcodeGroup_ERR ),
  /* C1  */ ( BxOpcodeGroup_XOP_0x9_C1 ),
  /* C2  */ ( BxOpcodeGroup_XOP_0x9_C2 ),
  /* C3  */ ( BxOpcodeGroup_XOP_0x9_C3 ),
  /* C4  */ ( BxOpcodeGroup_ERR ),
  /* C5  */ ( BxOpcodeGroup_ERR ),
  /* C6  */ ( BxOpcodeGroup_XOP_0x9_C6 ),
  /* C7  */ ( BxOpcodeGroup_XOP_0x9_C7 ),
  /* C8  */ ( BxOpcodeGroup_ERR ),
  /* C9  */ ( BxOpcodeGroup_ERR ),
  /* CA  */ ( BxOpcodeGroup_ERR ),
  /* CB  */ ( BxOpcodeGroup_XOP_0x9_CB ),
  /* CC  */ ( BxOpcodeGroup_ERR ),
  /* CD  */ ( BxOpcodeGroup_ERR ),
  /* CE  */ ( BxOpcodeGroup_ERR ),
  /* CF  */ ( BxOpcodeGroup_ERR ),
  /* D0  */ ( BxOpcodeGroup_ERR ),
  /* D1  */ ( BxOpcodeGroup_XOP_0x9_D1 ),
  /* D2  */ ( BxOpcodeGroup_XOP_0x9_D2 ),
  /* D3  */ ( BxOpcodeGroup_XOP_0x9_D3 ),
  /* D4  */ ( BxOpcodeGroup_ERR ),
  /* D5  */ ( BxOpcodeGroup_ERR ),
  /* D6  */ ( BxOpcodeGroup_XOP_0x9_D6 ),
  /* D7  */ ( BxOpcodeGroup_XOP_0x9_D7 ),
  /* D8  */ ( BxOpcodeGroup_ERR ),
  /* D9  */ ( BxOpcodeGroup_ERR ),
  /* DA  */ ( BxOpcodeGroup_ERR ),
  /* DB  */ ( BxOpcodeGroup_XOP_0x9_DB ),
  /* DC  */ ( BxOpcodeGroup_ERR ),
  /* DD  */ ( BxOpcodeGroup_ERR ),
  /* DF  */ ( BxOpcodeGroup_ERR ),
  /* DE  */ ( BxOpcodeGroup_ERR ),
  /* E0  */ ( BxOpcodeGroup_ERR ),
  /* E1  */ ( BxOpcodeGroup_XOP_0x9_E1 ),
  /* E2  */ ( BxOpcodeGroup_XOP_0x9_E2 ),
  /* E3  */ ( BxOpcodeGroup_XOP_0x9_E3 ),
  /* E4  */ ( BxOpcodeGroup_ERR ),
  /* E5  */ ( BxOpcodeGroup_ERR ),
  /* E6  */ ( BxOpcodeGroup_ERR ),
  /* E7  */ ( BxOpcodeGroup_ERR ),
  /* E8  */ ( BxOpcodeGroup_ERR ),
  /* E9  */ ( BxOpcodeGroup_ERR ),
  /* EA  */ ( BxOpcodeGroup_ERR ),
  /* EB  */ ( BxOpcodeGroup_ERR ),
  /* EC  */ ( BxOpcodeGroup_ERR ),
  /* ED  */ ( BxOpcodeGroup_ERR ),
  /* EE  */ ( BxOpcodeGroup_ERR ),
  /* EF  */ ( BxOpcodeGroup_ERR ),
  /* F0  */ ( BxOpcodeGroup_ERR ),
  /* F1  */ ( BxOpcodeGroup_ERR ),
  /* F2  */ ( BxOpcodeGroup_ERR ),
  /* F3  */ ( BxOpcodeGroup_ERR ),
  /* F4  */ ( BxOpcodeGroup_ERR ),
  /* F5  */ ( BxOpcodeGroup_ERR ),
  /* F6  */ ( BxOpcodeGroup_ERR ),
  /* F7  */ ( BxOpcodeGroup_ERR ),
  /* F8  */ ( BxOpcodeGroup_ERR ),
  /* F9  */ ( BxOpcodeGroup_ERR ),
  /* FA  */ ( BxOpcodeGroup_ERR ),
  /* FB  */ ( BxOpcodeGroup_ERR ),
  /* FC  */ ( BxOpcodeGroup_ERR ),
  /* FD  */ ( BxOpcodeGroup_ERR ),
  /* FE  */ ( BxOpcodeGroup_ERR ),
  /* FF  */ ( BxOpcodeGroup_ERR ),

  // 256 entries for XOP-encoded map 0xA opcodes
  /* 00  */ ( BxOpcodeGroup_ERR ),
  /* 01  */ ( BxOpcodeGroup_ERR ),
  /* 02  */ ( BxOpcodeGroup_ERR ),
  /* 03  */ ( BxOpcodeGroup_ERR ),
  /* 04  */ ( BxOpcodeGroup_ERR ),
  /* 05  */ ( BxOpcodeGroup_ERR ),
  /* 06  */ ( BxOpcodeGroup_ERR ),
  /* 07  */ ( BxOpcodeGroup_ERR ),
  /* 08  */ ( BxOpcodeGroup_ERR ),
  /* 09  */ ( BxOpcodeGroup_ERR ),
  /* 0A  */ ( BxOpcodeGroup_ERR ),
  /* 0B  */ ( BxOpcodeGroup_ERR ),
  /* 0C  */ ( BxOpcodeGroup_ERR ),
  /* 0D  */ ( BxOpcodeGroup_ERR ),
  /* 0E  */ ( BxOpcodeGroup_ERR ),
  /* 0F  */ ( BxOpcodeGroup_ERR ),
  /* 10  */ ( BxOpcodeGroup_XOP_0xA_10 ),
  /* 11  */ ( BxOpcodeGroup_ERR ),
  /* 12  */ ( BxOpcodeGroup_ERR ),
  /* 13  */ ( BxOpcodeGroup_ERR ),
  /* 14  */ ( BxOpcodeGroup_ERR ),
  /* 15  */ ( BxOpcodeGroup_ERR ),
  /* 16  */ ( BxOpcodeGroup_ERR ),
  /* 17  */ ( BxOpcodeGroup_ERR ),
  /* 18  */ ( BxOpcodeGroup_ERR ),
  /* 19  */ ( BxOpcodeGroup_ERR ),
  /* 1A  */ ( BxOpcodeGroup_ERR ),
  /* 1B  */ ( BxOpcodeGroup_ERR ),
  /* 1C  */ ( BxOpcodeGroup_ERR ),
  /* 1D  */ ( BxOpcodeGroup_ERR ),
  /* 1E  */ ( BxOpcodeGroup_ERR ),
  /* 1F  */ ( BxOpcodeGroup_ERR ),
  /* 20  */ ( BxOpcodeGroup_ERR ),
  /* 21  */ ( BxOpcodeGroup_ERR ),
  /* 22  */ ( BxOpcodeGroup_ERR ),
  /* 23  */ ( BxOpcodeGroup_ERR ),
  /* 24  */ ( BxOpcodeGroup_ERR ),
  /* 25  */ ( BxOpcodeGroup_ERR ),
  /* 26  */ ( BxOpcodeGroup_ERR ),
  /* 27  */ ( BxOpcodeGroup_ERR ),
  /* 28  */ ( BxOpcodeGroup_ERR ),
  /* 29  */ ( BxOpcodeGroup_ERR ),
  /* 2A  */ ( BxOpcodeGroup_ERR ),
  /* 2B  */ ( BxOpcodeGroup_ERR ),
  /* 2C  */ ( BxOpcodeGroup_ERR ),
  /* 2D  */ ( BxOpcodeGroup_ERR ),
  /* 2E  */ ( BxOpcodeGroup_ERR ),
  /* 2F  */ ( BxOpcodeGroup_ERR ),
  /* 30  */ ( BxOpcodeGroup_ERR ),
  /* 31  */ ( BxOpcodeGroup_ERR ),
  /* 32  */ ( BxOpcodeGroup_ERR ),
  /* 33  */ ( BxOpcodeGroup_ERR ),
  /* 34  */ ( BxOpcodeGroup_ERR ),
  /* 35  */ ( BxOpcodeGroup_ERR ),
  /* 36  */ ( BxOpcodeGroup_ERR ),
  /* 37  */ ( BxOpcodeGroup_ERR ),
  /* 38  */ ( BxOpcodeGroup_ERR ),
  /* 39  */ ( BxOpcodeGroup_ERR ),
  /* 3A  */ ( BxOpcodeGroup_ERR ),
  /* 3B  */ ( BxOpcodeGroup_ERR ),
  /* 3C  */ ( BxOpcodeGroup_ERR ),
  /* 3D  */ ( BxOpcodeGroup_ERR ),
  /* 3E  */ ( BxOpcodeGroup_ERR ),
  /* 3F  */ ( BxOpcodeGroup_ERR ),
  /* 40  */ ( BxOpcodeGroup_ERR ),
  /* 41  */ ( BxOpcodeGroup_ERR ),
  /* 42  */ ( BxOpcodeGroup_ERR ),
  /* 43  */ ( BxOpcodeGroup_ERR ),
  /* 44  */ ( BxOpcodeGroup_ERR ),
  /* 45  */ ( BxOpcodeGroup_ERR ),
  /* 46  */ ( BxOpcodeGroup_ERR ),
  /* 47  */ ( BxOpcodeGroup_ERR ),
  /* 48  */ ( BxOpcodeGroup_ERR ),
  /* 49  */ ( BxOpcodeGroup_ERR ),
  /* 4A  */ ( BxOpcodeGroup_ERR ),
  /* 4B  */ ( BxOpcodeGroup_ERR ),
  /* 4C  */ ( BxOpcodeGroup_ERR ),
  /* 4D  */ ( BxOpcodeGroup_ERR ),
  /* 4E  */ ( BxOpcodeGroup_ERR ),
  /* 4F  */ ( BxOpcodeGroup_ERR ),
  /* 50  */ ( BxOpcodeGroup_ERR ),
  /* 51  */ ( BxOpcodeGroup_ERR ),
  /* 52  */ ( BxOpcodeGroup_ERR ),
  /* 53  */ ( BxOpcodeGroup_ERR ),
  /* 54  */ ( BxOpcodeGroup_ERR ),
  /* 55  */ ( BxOpcodeGroup_ERR ),
  /* 56  */ ( BxOpcodeGroup_ERR ),
  /* 57  */ ( BxOpcodeGroup_ERR ),
  /* 58  */ ( BxOpcodeGroup_ERR ),
  /* 59  */ ( BxOpcodeGroup_ERR ),
  /* 5A  */ ( BxOpcodeGroup_ERR ),
  /* 5B  */ ( BxOpcodeGroup_ERR ),
  /* 5C  */ ( BxOpcodeGroup_ERR ),
  /* 5D  */ ( BxOpcodeGroup_ERR ),
  /* 5E  */ ( BxOpcodeGroup_ERR ),
  /* 5F  */ ( BxOpcodeGroup_ERR ),
  /* 60  */ ( BxOpcodeGroup_ERR ),
  /* 61  */ ( BxOpcodeGroup_ERR ),
  /* 62  */ ( BxOpcodeGroup_ERR ),
  /* 63  */ ( BxOpcodeGroup_ERR ),
  /* 64  */ ( BxOpcodeGroup_ERR ),
  /* 65  */ ( BxOpcodeGroup_ERR ),
  /* 66  */ ( BxOpcodeGroup_ERR ),
  /* 67  */ ( BxOpcodeGroup_ERR ),
  /* 68  */ ( BxOpcodeGroup_ERR ),
  /* 69  */ ( BxOpcodeGroup_ERR ),
  /* 6A  */ ( BxOpcodeGroup_ERR ),
  /* 6B  */ ( BxOpcodeGroup_ERR ),
  /* 6C  */ ( BxOpcodeGroup_ERR ),
  /* 6D  */ ( BxOpcodeGroup_ERR ),
  /* 6E  */ ( BxOpcodeGroup_ERR ),
  /* 6F  */ ( BxOpcodeGroup_ERR ),
  /* 70  */ ( BxOpcodeGroup_ERR ),
  /* 71  */ ( BxOpcodeGroup_ERR ),
  /* 72  */ ( BxOpcodeGroup_ERR ),
  /* 73  */ ( BxOpcodeGroup_ERR ),
  /* 74  */ ( BxOpcodeGroup_ERR ),
  /* 75  */ ( BxOpcodeGroup_ERR ),
  /* 76  */ ( BxOpcodeGroup_ERR ),
  /* 77  */ ( BxOpcodeGroup_ERR ),
  /* 78  */ ( BxOpcodeGroup_ERR ),
  /* 79  */ ( BxOpcodeGroup_ERR ),
  /* 7A  */ ( BxOpcodeGroup_ERR ),
  /* 7B  */ ( BxOpcodeGroup_ERR ),
  /* 7C  */ ( BxOpcodeGroup_ERR ),
  /* 7D  */ ( BxOpcodeGroup_ERR ),
  /* 7E  */ ( BxOpcodeGroup_ERR ),
  /* 7F  */ ( BxOpcodeGroup_ERR ),
  /* 80  */ ( BxOpcodeGroup_ERR ),
  /* 81  */ ( BxOpcodeGroup_ERR ),
  /* 82  */ ( BxOpcodeGroup_ERR ),
  /* 83  */ ( BxOpcodeGroup_ERR ),
  /* 84  */ ( BxOpcodeGroup_ERR ),
  /* 85  */ ( BxOpcodeGroup_ERR ),
  /* 86  */ ( BxOpcodeGroup_ERR ),
  /* 87  */ ( BxOpcodeGroup_ERR ),
  /* 88  */ ( BxOpcodeGroup_ERR ),
  /* 89  */ ( BxOpcodeGroup_ERR ),
  /* 8A  */ ( BxOpcodeGroup_ERR ),
  /* 8B  */ ( BxOpcodeGroup_ERR ),
  /* 8C  */ ( BxOpcodeGroup_ERR ),
  /* 8D  */ ( BxOpcodeGroup_ERR ),
  /* 8E  */ ( BxOpcodeGroup_ERR ),
  /* 8F  */ ( BxOpcodeGroup_ERR ),
  /* 90  */ ( BxOpcodeGroup_ERR ),
  /* 91  */ ( BxOpcodeGroup_ERR ),
  /* 92  */ ( BxOpcodeGroup_ERR ),
  /* 93  */ ( BxOpcodeGroup_ERR ),
  /* 94  */ ( BxOpcodeGroup_ERR ),
  /* 95  */ ( BxOpcodeGroup_ERR ),
  /* 96  */ ( BxOpcodeGroup_ERR ),
  /* 97  */ ( BxOpcodeGroup_ERR ),
  /* 98  */ ( BxOpcodeGroup_ERR ),
  /* 99  */ ( BxOpcodeGroup_ERR ),
  /* 9A  */ ( BxOpcodeGroup_ERR ),
  /* 9B  */ ( BxOpcodeGroup_ERR ),
  /* 9C  */ ( BxOpcodeGroup_ERR ),
  /* 9D  */ ( BxOpcodeGroup_ERR ),
  /* 9E  */ ( BxOpcodeGroup_ERR ),
  /* 9F  */ ( BxOpcodeGroup_ERR ),
  /* A0  */ ( BxOpcodeGroup_ERR ),
  /* A1  */ ( BxOpcodeGroup_ERR ),
  /* A2  */ ( BxOpcodeGroup_ERR ),
  /* A3  */ ( BxOpcodeGroup_ERR ),
  /* A4  */ ( BxOpcodeGroup_ERR ),
  /* A5  */ ( BxOpcodeGroup_ERR ),
  /* A6  */ ( BxOpcodeGroup_ERR ),
  /* A7  */ ( BxOpcodeGroup_ERR ),
  /* A8  */ ( BxOpcodeGroup_ERR ),
  /* A9  */ ( BxOpcodeGroup_ERR ),
  /* AA  */ ( BxOpcodeGroup_ERR ),
  /* AB  */ ( BxOpcodeGroup_ERR ),
  /* AC  */ ( BxOpcodeGroup_ERR ),
  /* AD  */ ( BxOpcodeGroup_ERR ),
  /* AE  */ ( BxOpcodeGroup_ERR ),
  /* AF  */ ( BxOpcodeGroup_ERR ),
  /* B0  */ ( BxOpcodeGroup_ERR ),
  /* B1  */ ( BxOpcodeGroup_ERR ),
  /* B2  */ ( BxOpcodeGroup_ERR ),
  /* B3  */ ( BxOpcodeGroup_ERR ),
  /* B4  */ ( BxOpcodeGroup_ERR ),
  /* B5  */ ( BxOpcodeGroup_ERR ),
  /* B6  */ ( BxOpcodeGroup_ERR ),
  /* B7  */ ( BxOpcodeGroup_ERR ),
  /* B8  */ ( BxOpcodeGroup_ERR ),
  /* B9  */ ( BxOpcodeGroup_ERR ),
  /* BA  */ ( BxOpcodeGroup_ERR ),
  /* BB  */ ( BxOpcodeGroup_ERR ),
  /* BC  */ ( BxOpcodeGroup_ERR ),
  /* BD  */ ( BxOpcodeGroup_ERR ),
  /* BE  */ ( BxOpcodeGroup_ERR ),
  /* BF  */ ( BxOpcodeGroup_ERR ),
  /* C0  */ ( BxOpcodeGroup_ERR ),
  /* C1  */ ( BxOpcodeGroup_ERR ),
  /* C2  */ ( BxOpcodeGroup_ERR ),
  /* C3  */ ( BxOpcodeGroup_ERR ),
  /* C4  */ ( BxOpcodeGroup_ERR ),
  /* C5  */ ( BxOpcodeGroup_ERR ),
  /* C6  */ ( BxOpcodeGroup_ERR ),
  /* C7  */ ( BxOpcodeGroup_ERR ),
  /* C8  */ ( BxOpcodeGroup_ERR ),
  /* C9  */ ( BxOpcodeGroup_ERR ),
  /* CA  */ ( BxOpcodeGroup_ERR ),
  /* CB  */ ( BxOpcodeGroup_ERR ),
  /* CC  */ ( BxOpcodeGroup_ERR ),
  /* CD  */ ( BxOpcodeGroup_ERR ),
  /* CE  */ ( BxOpcodeGroup_ERR ),
  /* CF  */ ( BxOpcodeGroup_ERR ),
  /* D0  */ ( BxOpcodeGroup_ERR ),
  /* D1  */ ( BxOpcodeGroup_ERR ),
  /* D2  */ ( BxOpcodeGroup_ERR ),
  /* D3  */ ( BxOpcodeGroup_ERR ),
  /* D4  */ ( BxOpcodeGroup_ERR ),
  /* D5  */ ( BxOpcodeGroup_ERR ),
  /* D6  */ ( BxOpcodeGroup_ERR ),
  /* D7  */ ( BxOpcodeGroup_ERR ),
  /* D8  */ ( BxOpcodeGroup_ERR ),
  /* D9  */ ( BxOpcodeGroup_ERR ),
  /* DA  */ ( BxOpcodeGroup_ERR ),
  /* DB  */ ( BxOpcodeGroup_ERR ),
  /* DC  */ ( BxOpcodeGroup_ERR ),
  /* DD  */ ( BxOpcodeGroup_ERR ),
  /* DE  */ ( BxOpcodeGroup_ERR ),
  /* DF  */ ( BxOpcodeGroup_ERR ),
  /* E0  */ ( BxOpcodeGroup_ERR ),
  /* E1  */ ( BxOpcodeGroup_ERR ),
  /* E2  */ ( BxOpcodeGroup_ERR ),
  /* E3  */ ( BxOpcodeGroup_ERR ),
  /* E4  */ ( BxOpcodeGroup_ERR ),
  /* E5  */ ( BxOpcodeGroup_ERR ),
  /* E6  */ ( BxOpcodeGroup_ERR ),
  /* E7  */ ( BxOpcodeGroup_ERR ),
  /* E8  */ ( BxOpcodeGroup_ERR ),
  /* E9  */ ( BxOpcodeGroup_ERR ),
  /* EA  */ ( BxOpcodeGroup_ERR ),
  /* EB  */ ( BxOpcodeGroup_ERR ),
  /* EC  */ ( BxOpcodeGroup_ERR ),
  /* ED  */ ( BxOpcodeGroup_ERR ),
  /* EE  */ ( BxOpcodeGroup_ERR ),
  /* EF  */ ( BxOpcodeGroup_ERR ),
  /* F0  */ ( BxOpcodeGroup_ERR ),
  /* F1  */ ( BxOpcodeGroup_ERR ),
  /* F2  */ ( BxOpcodeGroup_ERR ),
  /* F3  */ ( BxOpcodeGroup_ERR ),
  /* F4  */ ( BxOpcodeGroup_ERR ),
  /* F5  */ ( BxOpcodeGroup_ERR ),
  /* F6  */ ( BxOpcodeGroup_ERR ),
  /* F7  */ ( BxOpcodeGroup_ERR ),
  /* F8  */ ( BxOpcodeGroup_ERR ),
  /* F9  */ ( BxOpcodeGroup_ERR ),
  /* FA  */ ( BxOpcodeGroup_ERR ),
  /* FB  */ ( BxOpcodeGroup_ERR ),
  /* FC  */ ( BxOpcodeGroup_ERR ),
  /* FD  */ ( BxOpcodeGroup_ERR ),
  /* FE  */ ( BxOpcodeGroup_ERR ),
  /* FF  */ ( BxOpcodeGroup_ERR )
};

#endif // BX_SUPPORT_AVX

#endif // BX_XOP_FETCHDECODE_TABLES_H
