/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxcoo
 * Create date:	2006-01-06 19:03
 */

#include "RateMeasure.h"
#include "utils.h"

CRateMeasure::CRateMeasure()
: _upSpeed(IRateMeasure::NoLimitedSpeed)
, _downSpeed(IRateMeasure::NoLimitedSpeed)
, _lastTick(0)
, _upCount(0)
, _downCount(0)
{
}

CRateMeasure::~CRateMeasure()
{
}

void CRateMeasure::addClient(IRateMeasureClient* client)
{
	client->setReadPriority(0);
	client->setWritePriority(0);
	
	TRateMeasureCtx ctx;
	ctx.client = client;
	ctx.remove = false;
	
	_clientList.push_back(ctx);
}

void CRateMeasure::removeClient(IRateMeasureClient* client)
{
	TRateMeasureClientList::iterator iter = _clientList.begin();
	for(; iter!=_clientList.end(); ++iter)
	{
		if(iter->client == client)
		{
			iter->remove = true;
			break;
		}
	}
}

void CRateMeasure::resetAllPriority()
{
	TRateMeasureClientList::iterator iter = _clientList.begin();
	for(; iter!=_clientList.end();)
	{
		if(iter->remove)
		{
			iter = _clientList.erase(iter);
			continue;
		}
		
		iter->client->blockWrite(false);
		iter->client->blockRead(false);
		
		iter->client->setWritePriority(0);
		iter->client->setReadPriority(0);
		++iter;
	}
}

void CRateMeasure::blockReadAll(bool block)
{
}

void CRateMeasure::blockWriteAll(bool block)
{
}

void CRateMeasure::scheduleUpload()
{
	unsigned int activeCount[MaxPriorityLevel];
	for(unsigned int i=0; i<MaxPriorityLevel; ++i)
	{
		activeCount[i] = 0;
	}
	
	TRateMeasureClientList::iterator iter = _clientList.begin();
	for(; iter!=_clientList.end();)
	{
		if(iter->remove)
		{
			iter = _clientList.erase(iter);
			continue;
		}
		
		if(iter->client->canWrite())
		{
			activeCount[iter->client->getWritePriority()]++;
		}
		
		++iter;
	}	
	
	for(unsigned int i=0; i<MaxPriorityLevel; ++i)
	{
		if(activeCount[i] == 0)
		{
			continue;
		}
		
		if(_upSpeed <= _upCount)
		{
			TRateMeasureClientList::iterator iter = _clientList.begin();
			for(; iter!=_clientList.end(); ++iter)
			{
				if(iter->client->getWritePriority() == i
					&& iter->client->canWrite())
				{
					iter->client->blockWrite(true);			
				}
			}
			continue;
		}
		
		unsigned int leftCount = _upSpeed - _upCount;
		unsigned int writeCount = leftCount / activeCount[i];
		if(writeCount < 512)
		{
			writeCount = 512;
		}		

		TRateMeasureClientList::iterator iter = _clientList.begin();
		for(; iter!=_clientList.end(); ++iter)
		{
			if(iter->client->getWritePriority() == i
				&& iter->client->canWrite())
			{
				unsigned int ret = iter->client->doWrite(writeCount);
				_upCount += ret;
				
				if((ret > 0)
					&& (i<MaxPriorityLevel-1))
				{
					iter->client->setWritePriority(i+1);
				}
								
				if(ret < leftCount)
				{
					leftCount -= ret;
				}
				else
				{
					leftCount = 0;
					break;
				}
			}
		}			
	}			
}

void CRateMeasure::scheduleDownload()
{
	unsigned int activeCount[MaxPriorityLevel];
	for(unsigned int i=0; i<MaxPriorityLevel; ++i)
	{
		activeCount[i] = 0;
	}
	
	TRateMeasureClientList::iterator iter = _clientList.begin();
	for(; iter!=_clientList.end();)
	{
		if(iter->remove)
		{
			iter = _clientList.erase(iter);
			continue;
		}
		
		if(iter->client->canRead())
		{
			activeCount[iter->client->getReadPriority()]++;
		}
		
		++iter;
	}	
	
	for(unsigned int i=0; i<MaxPriorityLevel; ++i)
	{
		if(activeCount[i] == 0)
		{
			continue;
		}
				
		if(_downSpeed <= _downCount)
		{
			TRateMeasureClientList::iterator iter = _clientList.begin();
			for(; iter!=_clientList.end(); ++iter)
			{
				if(iter->client->getReadPriority() == i
					&& iter->client->canRead())
				{
					iter->client->blockRead(true);			
				}
			}			
			continue;
		}
		
		unsigned int leftCount = _downSpeed - _downCount;
		unsigned int readCount = leftCount / activeCount[i];
		if(readCount < 512)
		{
			readCount = 512;
		}
				
		TRateMeasureClientList::iterator iter = _clientList.begin();
		for(; iter!=_clientList.end(); ++iter)
		{
			if(iter->client->getReadPriority() == i
				&& iter->client->canRead())
			{
				unsigned int ret = iter->client->doRead(readCount);
				_downCount += ret;
				
				if((ret > 0)
					&& (i<MaxPriorityLevel-1))
				{
					iter->client->setReadPriority(i+1);
				}
								
				if(ret < leftCount)
				{
					leftCount -= ret;
				}
				else
				{
					leftCount = 0;
					break;
				}
			}
		}			
	}			
}

void CRateMeasure::update()
{
	unsigned int tick = GetTickCount();
	if(tick - _lastTick > 1000)
	{
		resetAllPriority();
		_lastTick = tick;
		_upCount = 0;
		_downCount = 0;
	}
	
	scheduleUpload();
	scheduleDownload();	
}

void CRateMeasure::setUploadSpeed(unsigned int sp)
{
	_upSpeed = sp;
}

void CRateMeasure::setDownloadSpeed(unsigned int sp)
{
	_downSpeed = sp;
}

unsigned int CRateMeasure::getUploadSpeed()
{
	return _upSpeed;
}

unsigned int CRateMeasure::getDownloadSpeed()
{
	return _downSpeed;
}
