/*

    Bist: a chemical drawing tool
    Copyright (C) 2010 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0107


#include <config.h>

#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <2D_vector.hpp>

#include <util.hpp>


#include <change_layer.hpp>
#include <change_layer_dialog.hpp>

extern finestra_pr* MainWindow;

void change_layer_dialog_up_cb(Fl_Widget* w , void* d){
  ChangeLayerDialog* win=dynamic_cast<ChangeLayerDialog*>(w->parent());
  win->push_up();
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void change_layer_dialog_down_cb(Fl_Widget* w , void* d){
  ChangeLayerDialog* win=dynamic_cast<ChangeLayerDialog*>(w->parent());
  win->push_down();
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}


void change_layer_dialog_background_cb(Fl_Widget* w , void* d){
  ChangeLayerDialog* win=dynamic_cast<ChangeLayerDialog*>(w->parent());
  win->push_down(true);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}

void change_layer_dialog_foreground_cb(Fl_Widget* w , void* d){
  ChangeLayerDialog* win=dynamic_cast<ChangeLayerDialog*>(w->parent());
  win->push_up(true);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  ed->redraw();
}


ChangeLayerDialog::ChangeLayerDialog(ChangeLayer* plugin)
  :Fl_Double_Window(LARG_BUTTON_DEFAULT*4+9, LARG_BUTTON_DEFAULT+6, "Change layer"),
   _up(3, 3, LARG_BUTTON_DEFAULT,LARG_BUTTON_DEFAULT, "@8->"),
   _down(LARG_BUTTON_DEFAULT+3, 3, 
         LARG_BUTTON_DEFAULT, LARG_BUTTON_DEFAULT, "@2->"),
   _back(LARG_BUTTON_DEFAULT*2+3, 3, 
         LARG_BUTTON_DEFAULT, LARG_BUTTON_DEFAULT, "@<<"),
   _foreg(LARG_BUTTON_DEFAULT*3+3, 3, 
          LARG_BUTTON_DEFAULT, LARG_BUTTON_DEFAULT, "@4<<"),
   _plugin(plugin)

{
   labeltype(FL_NORMAL_LABEL);
   
   _up.callback(change_layer_dialog_up_cb);
   add(_up);

   _down.callback(change_layer_dialog_down_cb);
   add(_up);


   _back.callback(change_layer_dialog_background_cb);
   add(_back);

   _foreg.callback(change_layer_dialog_foreground_cb);
   add(_foreg);

   end();

   set_modal();
   show();
  
}

ChangeLayerDialog::~ChangeLayerDialog(){ }


void ChangeLayerDialog::push_down(bool go_background){
  _plugin->push_down(go_background);
}

void ChangeLayerDialog::push_up(bool go_foreground){
  _plugin->push_up(go_foreground);
}
