//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_1.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot1(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[1] = {1.500000000000000e+00};
  constexpr double aw[1] = {4.431134627263790e-01};
  constexpr double x[384] = {  1.057986693394197e+00, -7.144282222753716e-02, -2.054859453327102e-04,  2.331146756779162e-04,  1.331077830017425e-06,
 -1.115171509111191e-06, -8.999527162393619e-09,  5.640469957441268e-09,  5.868492293682324e-11, -2.886120987688697e-11, -3.681089987315752e-13,  1.487463219474723e-13,
  7.851220690400758e-01, -6.306370112940925e-02,  2.077090515664856e-03,  1.107583656237493e-04, -1.277451547927649e-05, -1.044487389335647e-08,  6.009838083002671e-08,
 -2.175115414441252e-09, -2.080059059032380e-10,  1.804354748413915e-11,  3.447550363921192e-13, -9.980335735361091e-14,  5.700728455141461e-01, -4.424389871474052e-02,
  2.353767967817790e-03, -4.387325740927295e-05, -5.008798807766955e-06,  4.884288295089779e-07, -1.173290746093463e-08, -1.185932002907759e-09,  1.202903061066997e-10,
 -2.735219425546217e-12, -3.083533159109398e-13,  2.983920551688735e-14,  4.263165133101116e-01, -2.826877076462550e-02,  1.603798639833974e-03, -6.621801200235662e-05,
  9.705629527727786e-07,  1.168434546975322e-07, -1.170416650328710e-08,  5.063515401445807e-10, -9.010812787342137e-13, -1.489830494944563e-12,  1.095625215815169e-13,
 -3.294304605340185e-15,  3.343787695313898e-01, -1.825217046123134e-02,  9.421690541285707e-04, -4.289019050586966e-05,  1.506333938826640e-06, -2.375199158095306e-08,
 -1.642802891862454e-09,  1.802845072073252e-10, -9.557839910687163e-12,  2.790196517090680e-13,  1.998323378968711e-15, -7.883517764092141e-16,  2.737062959617326e-01,
 -1.240744574659713e-02,  5.529249190801726e-04, -2.352162653738726e-05,  9.051198513379506e-07, -2.839050037196454e-08,  5.109421933983436e-10,  1.407039538947661e-11,
 -1.949673343458228e-12,  1.127750829710148e-13, -4.374187315635119e-15,  1.015963850541615e-16,  2.314321486648044e-01, -8.905431552066596e-03,  3.411221934963245e-04,
 -1.287092914971452e-05,  4.676183879261686e-07, -1.569514089798894e-08,  4.499257284264834e-10, -8.827025894078617e-12, -4.528147109906610e-14,  1.575661232617235e-14,
 -9.771178325583664e-16,  4.140295847801633e-17,  2.004425977723634e-01, -6.687523573427587e-03,  2.228778169247477e-04, -7.395888424548810e-06,  2.423064077452070e-07,
 -7.701382214546719e-09,  2.300343695813390e-10, -6.089986328575896e-12,  1.239443061683193e-13, -7.602553606340901e-16, -9.582281811754662e-17,  6.715820944592601e-18,
  1.767762141109114e-01, -5.203610350329985e-03,  1.531372602004397e-04, -4.501650850226160e-06,  1.318227678779673e-07, -3.819713632881610e-09,  1.080449216432170e-10,
 -2.911511025958435e-12,  7.155059166417748e-14, -1.459122203961374e-15,  1.714723604801397e-17,  3.878715586059126e-19,  1.581138140629937e-01, -4.163747036495255e-03,
  1.096420218213107e-04, -2.886384528312645e-06,  7.590574699775137e-08, -1.989587919128444e-09,  5.170552283026493e-11, -1.318402418151381e-12,  3.237169261565035e-14,
 -7.407527938951930e-16,  1.480711182046233e-17, -2.146133793937241e-19,  1.430193785658226e-01, -3.407151823652130e-03,  8.116779623216395e-05, -1.933526852665239e-06,
  4.604702000492541e-08, -1.095581820289707e-09,  2.599519200175242e-11, -6.125793140220651e-13,  1.422136136841771e-14, -3.206123921352768e-16,  6.847741816300389e-18,
 -1.323580050468122e-19,  1.305582405744536e-01, -2.839564625134561e-03,  6.175873588666825e-05, -1.343196519956186e-06,  2.921147589499571e-08, -6.351259069163048e-10,
  1.379793425287233e-11, -2.990809553309502e-13,  6.447556601376684e-15, -1.373798642932894e-16,  2.861296678012272e-18, -5.715160818258370e-20,  1.200961151572054e-01,
 -2.402883759028992e-03,  4.807689503210470e-05, -9.619199787150217e-07,  1.924577355659989e-08, -3.850393897402355e-10,  7.701558903062076e-12, -1.539414978130730e-13,
  3.071428657261740e-15, -6.101756808188811e-17,  1.201180640067729e-18, -2.322474804736961e-20,  1.111873974714942e-01, -2.059732465291284e-03,  3.815628079219078e-05,
 -7.068398697088741e-07,  1.309407210509106e-08, -2.425616628010063e-10,  4.493087025526283e-12, -8.321161507172306e-14,  1.540203208176981e-15, -2.846673371464526e-17,
  5.243582978061400e-19, -9.587378206994651e-21,  1.035098338974698e-01, -1.785183137531318e-03,  3.078817421220887e-05, -5.309884233881554e-07,  9.157689161265787e-09,
 -1.579375283561523e-10,  2.723822044721043e-12, -4.697317805182187e-14,  8.099353198328178e-16, -1.395889191299331e-17,  2.402965421906549e-19, -4.124487881562381e-21,
  9.682458365464176e-02, -1.562093310508541e-03,  2.520161113926371e-05, -4.065833892823905e-07,  6.559502515141727e-09, -1.058258753430705e-10,  1.707306223526556e-12,
 -2.754389672061436e-14,  4.443447182854592e-16, -7.167301793964512e-18,  1.155660357036138e-19, -1.861209421046733e-21,  9.095085938854892e-02, -1.378359824587057e-03,
  2.088903632332902e-05, -3.165732411070342e-07,  4.797665769217359e-09, -7.270858827993690e-11,  1.101897296636707e-12, -1.669918096052681e-14,  2.530720658696433e-16,
 -3.835100826358939e-18,  5.811134365390768e-20, -8.800694329041991e-22,  8.574929257124383e-02, -1.225239993899981e-03,  1.750700207026308e-05, -2.501510910788369e-07,
  3.574316597596288e-09, -5.107208887892981e-11,  7.297500866742994e-13, -1.042712007914412e-14,  1.489887058346579e-16, -2.128815092662221e-18,  3.041646382120743e-20,
 -4.344618678335355e-22,  8.111071056537980e-02, -1.096290919106305e-03,  1.481744853332377e-05, -2.002723703977008e-07,  2.706877787982895e-09, -3.658611170781422e-11,
  4.944972139946927e-13, -6.683614174622216e-15,  9.033552960658669e-17, -1.220969179453738e-18,  1.650239748312328e-20, -2.229968378756115e-22,  7.694837640638635e-02,
 -9.866798490756386e-04,  1.265182152029981e-05, -1.622295093272588e-07,  2.080207474479467e-09, -2.667371152017094e-11,  3.420268843585154e-13, -4.385680836693997e-15,
  5.623591072936953e-17, -7.210911539448567e-19,  9.246249596817101e-21, -1.185404358058847e-22,  7.319250547113997e-02, -8.927243167395140e-04,  1.088850150118277e-05,
 -1.328063577050375e-07,  1.619830666731022e-09, -1.975697122970543e-11,  2.409745164363792e-13, -2.939150766386149e-15,  3.584863264978267e-17, -4.372433983921355e-19,
  5.333025633602838e-21, -6.503672283796038e-23,  6.978631577988531e-02, -8.115785350685460e-04,  9.438236009785576e-06, -1.097617730474387e-07,  1.276472299480924e-09,
 -1.484470855413484e-11,  1.726362351034134e-13, -2.007669568920946e-15,  2.334815204849949e-17, -2.715268456353038e-19,  3.157715275344596e-21, -3.671759456771296e-23,
  6.668313367115805e-02, -7.410152021126283e-04,  8.234518978515185e-06, -9.150595374319278e-08,  1.016858372940869e-09, -1.129982157788204e-11,  1.255690773493143e-13,
 -1.395384260947041e-15,  1.550618411413408e-17, -1.723122086361966e-19,  1.914816411580889e-21, -2.127573437600437e-23,  6.384423980690615e-02, -6.792709245887912e-04,
  7.227104440231730e-06, -7.689279299218559e-08,  8.181010338282292e-10, -8.704187681385158e-12,  9.260822326244377e-14, -9.853053873845546e-16,  1.048315875054867e-17,
 -1.115355894803848e-19,  1.186683113722182e-21, -1.262428794520145e-23,  6.123724356957945e-02, -6.249349093931703e-04,  6.377550951236128e-06, -6.508382797035222e-08,
  6.641898584053275e-10, -6.778153371822801e-12,  6.917203349381316e-14, -7.059105858388098e-16,  7.203919416475140e-18, -7.351703739951724e-20,  7.502519680997237e-22,
 -7.655632257320562e-24,  5.883484054145521e-02, -5.768676142156884e-04,  5.656108545011271e-06, -5.545737546117121e-08,  5.437520281950621e-10, -5.331414725409118e-12,
  5.227379669488312e-14, -5.125374711271604e-16,  5.025360236198257e-18, -4.927297402477483e-20,  4.831148080528969e-22, -4.736419676927769e-24,  5.661385170722979e-02,
 -5.341404831787391e-04,  5.039509716559036e-06, -4.754677651870560e-08,  4.485944237574224e-10, -4.232399581222562e-12,  3.993185217304065e-14, -3.767491200602163e-16,
  3.554553363832264e-18, -3.353650730252294e-20,  3.164103047362650e-22, -2.985002873487706e-24,  5.455447255899810e-02, -4.959907448952424e-04,  4.509379478569656e-06,
 -4.099774741974261e-08,  3.727376020317001e-10, -3.388803744408602e-12,  3.080985324668412e-14, -2.801127266954748e-16,  2.546689821223788e-18, -2.315363932946449e-20,
  2.105050273731409e-22, -1.913682066835144e-24,  5.263968047576973e-02, -4.617871188746624e-04,  4.051075941783504e-06, -3.553848865704591e-08,  3.117651197303763e-10,
 -2.734992216986845e-12,  2.399300612412218e-14, -2.104811630895123e-16,  1.846468082670482e-18, -1.619833494965560e-20,  1.421015917085596e-22, -1.246505190398957e-24,
  5.085476277156078e-02, -4.310035220859456e-04,  3.652834580803000e-06, -3.095844880833592e-08,  2.623785806385094e-10, -2.223707008192934e-12,  1.884632825687528e-14,
 -1.597261183497956e-16,  1.353708400668723e-18, -1.147292911749707e-20,  9.723519614044817e-23, -8.240270859322372e-25,  4.918693768379647e-02, -4.031987115847757e-04,
  3.305129546155459e-06, -2.709304619038437e-08,  2.220890714338660e-10, -1.820524547286319e-12,  1.492333506495387e-14, -1.223306380531084e-16,  1.002777525355174e-18,
 -8.220040223452146e-21,  6.738190601767012e-23, -5.523107050623459e-25,  4.762504762507144e-02, -3.780003795005700e-04,  3.000192000382501e-06, -2.381254762508930e-08,
  1.890003787507110e-10, -1.500097500289126e-12,  1.190628571883334e-14, -9.450028387566298e-17,  7.500495001942498e-19, -5.953148812565445e-21,  4.725018900051778e-23,
 -3.750015000040365e-25  };
  constexpr double w[384] = {  4.135653584758195e-01, -1.066439704592393e-01,  1.752146780833233e-02, -2.154035108083543e-03,  2.123679824895491e-04,
 -1.749369492647350e-05,  1.237819265129784e-06, -7.676522952021522e-08,  4.237208259260642e-09, -2.107052960597916e-10,  9.532877171342738e-12, -3.950665544868368e-13,
  1.599461505363333e-01, -3.096198038212439e-02,  4.255772773271153e-03, -4.654909238812563e-04,  4.233489892280168e-05, -3.289699797763587e-06,  2.227993127460179e-07,
 -1.335652563041112e-08,  7.176391768087074e-10, -3.491410473430721e-11,  1.551298009286964e-12, -6.332303946483246e-14,  8.026264548904928e-02, -1.133995737427459e-02,
  1.243259373351908e-03, -1.159576319402131e-04,  9.415673853935415e-06, -6.737652179339188e-07,  4.291072677258729e-08, -2.454290753729082e-09,  1.271030018274720e-10,
 -6.004510636076742e-12,  2.604804363995930e-13, -1.042458350064328e-14,  4.859569796092199e-02, -5.148911980098271e-03,  4.438751383843736e-04, -3.424488814882181e-05,
  2.404895705877444e-06, -1.541735418447310e-07,  9.032246467106875e-09, -4.844980385243089e-10,  2.386691820538419e-11, -1.083687867755238e-12,  4.553481216480986e-14,
 -1.775509251352928e-15,  3.318841541503713e-02, -2.763244316554662e-03,  1.905338480625239e-04, -1.207874145926498e-05,  7.193505769630907e-07, -4.034421045107958e-08,
  2.125092496484539e-09, -1.048140678382111e-10,  4.831960683319789e-12, -2.081263277623661e-13,  8.382481202901493e-15, -3.158203880028124e-16,  2.447924039107278e-02,
 -1.670337154526220e-03,  9.487009895039248e-05, -5.006890236939414e-06,  2.523646848363528e-07, -1.222934372643786e-08,  5.691127493146268e-10, -2.533371448326467e-11,
  1.074109554554316e-12, -4.322752799410106e-14,  1.647705940116275e-15, -5.935895690276484e-17,  1.901257983093334e-02, -1.097797176431922e-03,  5.282346462942369e-05,
 -2.369704966560619e-06,  1.022035381291580e-07, -4.282846433782955e-09,  1.747862721399167e-10, -6.934187011465713e-12,  2.664053821042440e-13, -9.868867536559238e-15,
  3.511211871133835e-16, -1.194910648313331e-17,  1.531866754435402e-02, -7.664545839261231e-04,  3.196393643077859e-05, -1.243885426763538e-06,  4.663965470028716e-08,
 -1.706421432978073e-09,  6.122804189144124e-11, -2.156405613094402e-12,  7.441977150769849e-14, -2.508524188712748e-15,  8.226685739996370e-17, -2.612347731342939e-18,
  1.268477574194269e-02, -5.599240346078043e-04,  2.060071644229961e-05, -7.074073551965400e-07,  2.341969436362825e-08, -7.576730424366755e-10,  2.410717114225890e-11,
 -7.564247508605618e-13,  2.341539700006752e-14, -7.141043632992439e-16,  2.140034617675300e-17, -6.276204210715181e-19,  1.072862287662884e-02, -4.236815957127729e-04,
  1.394531016987716e-05, -4.284172633161849e-07,  1.269106180327052e-08, -3.675409696214260e-10,  1.047863069206222e-11, -2.951796290593520e-13,  8.229608960255464e-15,
 -2.271270305495372e-16,  6.198869790374740e-18, -1.668561465030425e-19,  9.228695623565627e-03, -3.297131299395551e-04,  9.817758366971190e-06, -2.728598017704787e-07,
  7.312637893641860e-09, -1.916176195022723e-10,  4.944459162433632e-12, -1.261469327304046e-13,  3.189406294216692e-15, -8.000255819943310e-17,  1.991234616332444e-18,
 -4.911271281247086e-20,  8.048660322776655e-03, -2.625338887107062e-04,  7.137025038788259e-06, -1.810916752028764e-07,  4.430876648208031e-09, -1.060033991982483e-10,
  2.497516150226103e-12, -5.819196113628237e-14,  1.344291859419495e-15, -3.083708903932189e-17,  7.029905834445299e-19, -1.592076847859000e-20,  7.100466902341420e-03,
 -2.130672922355064e-04,  5.328547921968880e-06, -1.243794327640887e-07,  2.799613986105193e-09, -6.161539611874477e-11,  1.335512612964982e-12, -2.862854052218697e-14,
  6.085420723676045e-16, -1.284902965904507e-17,  2.697837302973300e-19, -5.633808751437497e-21,  6.324966011972775e-03, -1.757311768923202e-04,  4.069072701187250e-06,
 -8.794034532608399e-08,  1.832695466957234e-09, -3.734515753007592e-11,  7.494593519896410e-13, -1.487514839958279e-14,  2.927747683813691e-16, -5.724526544293141e-18,
  1.113289752186427e-19, -2.154426347039960e-21,  5.681099140852745e-03, -1.469522872531116e-04,  3.167899377741413e-06, -6.373988222908077e-08,  1.236687839418025e-09,
 -2.346122399237596e-11,  4.383403336434155e-13, -8.099782150469673e-15,  1.484224295599604e-16, -2.701922771248382e-18,  4.892614674764565e-20, -8.817653407041110e-22,
  5.139564276280682e-03, -1.243645221694533e-04,  2.507920247977568e-06, -4.720356285170548e-08,  8.567308298362593e-10, -1.520392014730100e-11,  2.657277809894234e-13,
 -4.593247384237508e-15,  7.873508869302429e-17, -1.340811796480891e-18,  2.271285871687245e-20, -3.829655292905190e-22,  4.678946550556683e-03, -1.063549572339188e-04,
  2.014703217768674e-06, -3.562110879848837e-08,  6.073122120068501e-10, -1.012413675034798e-11,  1.662164942930265e-13, -2.698930916722854e-15,  4.345855943362673e-17,
 -6.952018235722285e-19,  1.106251230120596e-20, -1.752273553681212e-22,  4.283269318842086e-03, -9.179605331848567e-05,  1.639508063160909e-06, -2.733036443695931e-08,
  4.393243128554762e-10, -6.905042006491795e-12,  1.068851730258372e-13, -1.636327055875213e-15,  2.484212332861477e-17, -3.746791908434509e-19,  5.621322243996755e-21,
 -8.395309013619787e-23,  3.940396043305408e-03, -7.988201151284797e-05,  1.349573985466081e-06, -2.128071127094307e-08,  3.235812117714724e-10, -4.810847708703187e-12,
  7.044171304931821e-14, -1.020092791670516e-15,  1.464925013993331e-17, -2.089986176400013e-19,  2.966058226349572e-21, -4.190307323916755e-23,  3.640959158449784e-03,
 -7.002564001642558e-05,  1.122367213065414e-06, -1.679013143131793e-08,  2.422036803923001e-10, -3.416240491374276e-12,  4.745544659255305e-14, -6.519662724509052e-16,
  8.882395784650675e-18, -1.202229591640969e-19,  1.618650135487074e-21, -2.169487867635906e-23,  3.377625055343649e-03, -6.179156849562061e-05,  9.420672508340389e-07,
 -1.340526515447216e-08,  1.839400324895536e-10, -2.467846138017629e-12,  3.260842198355359e-14, -4.261307664627624e-16,  5.522324302321272e-18, -7.109731733863023e-20,
  9.105269551140079e-22, -1.160856254088352e-23,  3.144579069692897e-03, -5.485194517482078e-05,  7.973609904840891e-07, -1.081828414100072e-08,  1.415366735605166e-10,
 -1.810591519744941e-12,  2.281086845722602e-14, -2.842264806526018e-16,  3.511988985652421e-18, -4.311158917850439e-20,  5.264331156728034e-22, -6.399481196589546e-24,
  2.937157824996331e-03, -4.895640832540258e-05,  6.800235834725452e-07, -8.816141034468411e-09,  1.102148610266473e-10, -1.347232710227029e-12,  1.621865681798140e-14,
 -1.931027712709452e-16,  2.279964073211056e-18, -2.674359393942946e-20,  3.120468565482904e-22, -3.624747587604266e-24,  2.751582327594653e-03, -4.391133493588563e-05,
  5.839851625408772e-07, -7.248811980568326e-09,  8.676385087918351e-11, -1.015433718747613e-12,  1.170399463984184e-14, -1.334190931564087e-16,  1.508230490745103e-18,
 -1.693829560234687e-20,  1.892256345942885e-22, -2.104519600504218e-24,  2.584761240793730e-03, -3.956524707720406e-05,  5.047047508050445e-07, -6.008976519042477e-09,
  6.898751233313386e-11, -7.744282563821105e-13,  8.561732222065785e-15, -9.361456201905489e-17,  1.015058398462874e-18, -1.093429783498432e-20,  1.171653073097142e-22,
 -1.249896817374903e-24,  2.434143871810106e-03, -3.579838410794356e-05,  4.387425901699890e-07, -5.018749879238761e-09,  5.535898083967781e-11, -5.970645754649600e-13,
  6.341970867074628e-15, -6.662365953662773e-17,  6.940624760109292e-19, -7.183248492750280e-21,  7.395226454323649e-23, -7.579713870401952e-25,  2.297608917210032e-03,
 -3.251514252254305e-05,  3.834631490292616e-07, -4.220858563891419e-09,  4.480068602231937e-11, -4.649531291505860e-13,  4.752294900901216e-15, -4.803954443047130e-17,
  4.815708693534111e-19, -4.795940360253550e-21,  4.751115597497762e-23, -4.685883728220409e-25,  2.173379292042435e-03, -2.963852137211661e-05,  3.368257383492216e-07,
 -3.572671024824223e-09,  3.654158788717742e-11, -3.654453283032621e-13,  3.599374959628388e-15, -3.506170609690566e-17,  3.386919083815422e-19, -3.250340274810860e-21,
  3.102852216804809e-23, -2.948970470639993e-25,  2.059956231480111e-03, -2.710599091783694e-05,  2.972348264873238e-07, -3.042096344982233e-09,  3.002291131612693e-11,
 -2.897164953813359e-13,  2.753361925182086e-15, -2.587942652059519e-17,  2.412191645113400e-19, -2.233681237769136e-21,  2.057495218055001e-23, -1.886844963996866e-25,
  1.956067801881088e-03, -2.486638490378408e-05,  2.634316497790524e-07, -2.604725597432706e-09,  2.483490579790712e-11, -2.315280471372690e-13,  2.125760555459292e-15,
 -1.930306780552970e-17,  1.738217573602923e-19, -1.555013481807576e-21,  1.383797140440405e-23, -1.226006718421754e-25,  1.860628303764434e-03, -2.287753822164470e-05,
  2.344147880046653e-07, -2.241812684402721e-09,  2.067379002693027e-11, -1.864152370643060e-13,  1.655435802264321e-15, -1.453933445336660e-17,  1.266317219503761e-19,
 -1.095702660121998e-21,  9.430857108371231e-24, -8.081536494792655e-26,  1.772705991748090e-03, -2.110447363715505e-05,  2.093813188035964e-07, -1.938830412437076e-09,
  1.731203545102832e-11, -1.511461004080499e-13,  1.299616981265166e-15, -1.105185166202646e-17,  9.320098747539451e-20, -7.808330630379991e-22,  6.507349278507902e-24,
 -5.399286049308797e-26  };
  int offset = -1;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 1;
    if (std::isnan(t)) {
      fill_n(rr+offset, 1, 0.5);
      fill_n(ww+offset, 1, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 1; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=1; ++j) {
        const int boxof = it*12+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
