#!/usr/bin/perl

use strict;
use warnings;

use lib '/usr/src/apt-cacher/src';

require 'lib/apt-cacher.pl';

our $cfg = read_config('/etc/apt-cacher/apt-cacher.conf');

my %h;

extract_sums('/var/cache/apt-cacher/packages/debian_dists_experimental_main_binary-i386_Packages.diff_Index', \%h);
extract_sums('/var/cache/apt-cacher/packages/titan:9999_debian_dists_unstable_contrib_binary-i386_Packages.bz2', \%h);
extract_sums('/var/cache/apt-cacher/packages/titan:9999_debian_dists_stable_contrib_source_Sources.bz2', \%h);
extract_sums('/var/cache/apt-cacher/packages/titan:9999_debian_dists_stable_Release', \%h);
extract_sums('/var/cache/apt-cacher/packages/titan_~mark_debian_Packages.gz', \%h);

foreach my $file (keys %h) {
    print "$file:\n";
    my $href = hashify(\$h{$file});
    foreach (keys %$href) {
	print " $_: $href->{$_}\n" if $href->{$_};
    }
}
