/*
 * Copyright © 2013 Keith Packard <keithp@keithp.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#ifndef _AO_EDITALTOS_H_
#define _AO_EDITALTOS_H_

#include <stdint.h>
#include <stdbool.h>
#include "ao-hex.h"

extern struct ao_sym ao_symbols[];
extern int ao_num_symbols;

#define AO_USB_DESC_STRING		3

#define AO_ROMCONFIG_VERSION	(ao_symbols[0].addr)
#define AO_ROMCONFIG_CHECK	(ao_symbols[1].addr)
#define AO_SERIAL_NUMBER	(ao_symbols[2].addr)
#define AO_RADIO_CAL		(ao_symbols[3].addr)
#define AO_USB_DESCRIPTORS	(ao_symbols[4].addr)

struct ao_editaltos_funcs {
	uint16_t	(*get_uint16)(void *closure, uint32_t addr);
	uint32_t	(*get_uint32)(void *closure, uint32_t addr);
};

bool
ao_editaltos_find_symbols(struct ao_sym *file_symbols, int num_file_symbols,
			  struct ao_sym *symbols, int num_symbols);

bool
ao_editaltos(struct ao_hex_image *image,
	     uint16_t serial,
	     uint32_t radio_cal);

#endif /* _AO_EDITALTOS_H_ */
