!!****m* ABINIT/interfaces_71_bse
!! NAME
!! interfaces_71_bse
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/71_bse
!!
!! COPYRIGHT
!! Copyright (C) 2010-2014 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: config/scripts/abilint . .
!!
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

module interfaces_71_bse

 implicit none

interface
 subroutine calc_optical_mels(Wfd,Kmesh,KS_Bst,Cryst,Psps,Pawtab,Hur,inclvkb,lomo_spin,lomo_min,max_band,nkbz,qpoint,opt_cvk)
  use defs_basis
  use m_wfs
  use m_bz_mesh
  use m_crystal
  use m_paw_commutator
  use m_pawtab
  use defs_datatypes
  implicit none
  integer,intent(in) :: inclvkb
  integer,intent(in) :: lomo_min
  integer,intent(in) :: max_band
  integer,intent(in) :: nkbz
  type(crystal_t),intent(in) :: Cryst
  type(ebands_t),intent(in) :: KS_Bst
  type(kmesh_t),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(wfd_t),target,intent(inout) :: Wfd
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Wfd%usepaw)
  integer,intent(in) :: lomo_spin(Wfd%nsppol)
  complex(dpc),intent(out) :: opt_cvk(lomo_min:max_band,lomo_min:max_band,nkbz,Wfd%nsppol)
  real(dp),intent(in) :: qpoint(3)
 end subroutine calc_optical_mels
end interface

interface
 subroutine exc_build_block(BSp,Cryst,Kmesh,Qmesh,ktabr,Gsph_x,Gsph_c,Vcp,Wfd,W,Hdr_bse,&  
  &  nfftot_osc,ngfft_osc,Psps,Pawtab,Pawang,Paw_pwff,rhxtwg_q0,is_resonant,fname)
  use m_vcoul
  use m_pawtab
  use m_wfs
  use defs_basis
  use m_bz_mesh
  use m_pawang
  use defs_datatypes
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_gsphere
  use m_screen
  use m_paw_pwij
  implicit none
  integer,intent(in) :: nfftot_osc
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(gsphere_t),intent(in) :: Gsph_c
  type(gsphere_t),intent(in) :: Gsph_x
  type(hdr_type),intent(inout) :: Hdr_bse
  type(kmesh_t),intent(in) :: Kmesh
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(kmesh_t),intent(in) :: Qmesh
  type(vcoul_t),intent(in) :: Vcp
  type(screen_t),intent(inout) :: W
  type(wfd_t),target,intent(inout) :: Wfd
  character(len=fnlen),intent(in) :: fname
  logical,intent(in) :: is_resonant
  integer,intent(in) :: ngfft_osc(18)
  type(paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: ktabr(nfftot_osc,BSp%nkbz)
  complex(gwpc),intent(in) :: rhxtwg_q0(BSp%npweps,BSp%lomo_min:BSp%nbnds, &
  &         BSp%lomo_min:BSp%nbnds,Wfd%nkibz,Wfd%nsppol)
 end subroutine exc_build_block
end interface

interface
 subroutine exc_build_ham(BSp,BS_files,Cryst,Kmesh,Qmesh,ktabr,Gsph_x,Gsph_c,Vcp,&  
  &  Wfd,W,Hdr_bse,nfftot_osc,ngfft_osc,Psps,Pawtab,Pawang,Paw_pwff)
  use m_vcoul
  use m_pawtab
  use m_wfs
  use m_bz_mesh
  use m_pawang
  use defs_datatypes
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_gsphere
  use m_screen
  use m_paw_pwij
  implicit none
  integer,intent(in) :: nfftot_osc
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(gsphere_t),intent(in) :: Gsph_c
  type(gsphere_t),intent(in) :: Gsph_x
  type(hdr_type),intent(inout) :: Hdr_bse
  type(kmesh_t),intent(in) :: Kmesh
  type(pawang_type),intent(in) :: Pawang
  type(pseudopotential_type),intent(in) :: Psps
  type(kmesh_t),intent(in) :: Qmesh
  type(vcoul_t),intent(in) :: Vcp
  type(screen_t),intent(inout) :: W
  type(wfd_t),target,intent(inout) :: Wfd
  integer,intent(in) :: ngfft_osc(18)
  type(paw_pwff_type),intent(in) :: Paw_pwff(Psps%ntypat*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat)
  integer,intent(in) :: ktabr(nfftot_osc,BSp%nkbz)
 end subroutine exc_build_ham
end interface

interface
 subroutine exc_den(BSp,BS_files,ngfft,nfftot,Kmesh,ktabr,Wfd)
  use m_bz_mesh
  use m_bs_defs
  use m_wfs
  implicit none
  integer,intent(in) :: nfftot
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(kmesh_t),intent(in) :: Kmesh
  type(wfd_t),intent(inout) :: Wfd
  integer,intent(in) :: ngfft(18)
  integer,intent(in) :: ktabr(nfftot,BSp%nkbz)
 end subroutine exc_den
end interface

interface
 subroutine exc_diago_resonant(Bsp,BS_files,Hdr_bse,prtvol,comm)
  use defs_abitypes
  use m_bs_defs
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: prtvol
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(hdr_type),intent(in) :: Hdr_bse
 end subroutine exc_diago_resonant
end interface

interface
 subroutine exc_print_eig(BSp,bseig_fname,gw_gap,exc_gap)
  use defs_basis
  use m_bs_defs
  implicit none
  type(excparam),intent(in) :: BSp
  character(len=*),intent(in) :: bseig_fname
  complex(dpc),intent(out) :: exc_gap
  complex(dpc),intent(in) :: gw_gap
 end subroutine exc_print_eig
end interface

interface
 subroutine exc_diago_coupling(Bsp,BS_files,Hdr_bse,prtvol,comm)
  use defs_abitypes
  use m_bs_defs
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: prtvol
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(hdr_type),intent(in) :: Hdr_bse
 end subroutine exc_diago_coupling
end interface

interface
 subroutine exc_diago_coupling_hegv(Bsp,BS_files,Hdr_bse,prtvol,comm)
  use defs_abitypes
  use m_bs_defs
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: prtvol
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(hdr_type),intent(in) :: Hdr_bse
 end subroutine exc_diago_coupling_hegv
end interface

interface
 subroutine exc_diago_driver(Wfd,Bsp,BS_files,KS_BSt,QP_BSt,Cryst,Kmesh,Psps,&  
  &  Pawtab,Hur,Hdr_bse,drude_plsmf)
  use defs_basis
  use m_wfs
  use m_bz_mesh
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use m_pawtab
  use defs_datatypes
  implicit none
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(hdr_type),intent(in) :: Hdr_bse
  type(ebands_t),intent(in) :: KS_BSt
  type(kmesh_t),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(ebands_t),intent(in) :: QP_BSt
  type(wfd_t),intent(inout) :: Wfd
  real(dp),intent(in) :: drude_plsmf
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Wfd%usepaw)
 end subroutine exc_diago_driver
end interface

interface
 subroutine exc_plot(Bsp,Bs_files,Wfd,Kmesh,Cryst,Psps,Pawtab,Pawrad,paw_add_onsite,spin_opt,which_fixed,eh_rcoord,nrcell,ngfftf)
  use m_pawrad
  use m_wfs
  use m_bz_mesh
  use defs_basis
  use m_bs_defs
  use m_crystal
  use m_pawtab
  use defs_datatypes
  implicit none
  integer,intent(in) :: spin_opt
  integer,intent(in) :: which_fixed
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: Bsp
  type(crystal_t),intent(in) :: Cryst
  type(kmesh_t),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(wfd_t),intent(inout) :: Wfd
  logical,intent(in) :: paw_add_onsite
  integer,intent(in) :: ngfftf(18)
  integer,intent(in) :: nrcell(3)
  type(pawrad_type),intent(in) :: Pawrad(Cryst%ntypat*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Wfd%usepaw)
  real(dp),intent(in) :: eh_rcoord(3)
 end subroutine exc_plot
end interface

interface
 subroutine build_spectra(BSp,BS_files,Cryst,Kmesh,KS_BSt,QP_BSt,Psps,Pawtab,Wfd,Hur,drude_plsmf,comm)
  use defs_basis
  use m_wfs
  use m_bz_mesh
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use m_pawtab
  use defs_datatypes
  implicit none
  integer,intent(in) :: comm
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(ebands_t),intent(in) :: KS_BSt
  type(kmesh_t),intent(in) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(ebands_t),intent(in) :: QP_BSt
  type(wfd_t),intent(inout) :: Wfd
  real(dp),intent(in) :: drude_plsmf
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Wfd%usepaw)
 end subroutine build_spectra
end interface

interface
 subroutine exc_write_data(BSp,BS_files,what,eps,dos)
  use defs_basis
  use m_bs_defs
  implicit none
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  character(len=*),intent(in) :: what
  real(dp),optional,intent(in) :: dos(BSp%nomega)
  complex(dpc),intent(in) :: eps(BSp%nomega,BSp%nq)
 end subroutine exc_write_data
end interface

interface
 subroutine exc_eps_rpa(nbnds,lomo_spin,lomo_min,homo_spin,Kmesh,Bst,nq,nsppol,opt_cvk,ucvol,broad,nomega,omega,eps_rpa,dos)
  use m_bz_mesh
  use defs_datatypes
  use defs_basis
  implicit none
  integer,intent(in) :: lomo_min
  integer,intent(in) :: nbnds
  integer,intent(in) :: nomega
  integer,intent(in) :: nq
  integer,intent(in) :: nsppol
  type(ebands_t),intent(in) :: BSt
  type(kmesh_t),intent(in) :: Kmesh
  real(dp),intent(in) :: broad
  real(dp),intent(in) :: ucvol
  real(dp),intent(out) :: dos(nomega)
  complex(dpc),intent(out) :: eps_rpa(nomega,nq)
  integer,intent(in) :: homo_spin(nsppol)
  integer,intent(in) :: lomo_spin(nsppol)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(in) :: opt_cvk(lomo_min:nbnds,lomo_min:nbnds,Kmesh%nbz,nsppol,nq)
 end subroutine exc_eps_rpa
end interface

interface
 subroutine exc_eps_resonant(Bsp,BS_files,lomo_min,max_band,nkbz,nsppol,opt_cvk,ucvol,nomega,omega,eps_exc,dos_exc)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: lomo_min
  integer,intent(in) :: max_band
  integer,intent(in) :: nkbz
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  real(dp),intent(in) :: ucvol
  real(dp),intent(out) :: dos_exc(nomega)
  complex(dpc),intent(out) :: eps_exc(nomega,BSp%nq)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(in) :: opt_cvk(lomo_min:max_band,lomo_min:max_band,nkbz,nsppol,BSp%nq)
 end subroutine exc_eps_resonant
end interface

interface
 subroutine exc_eps_coupling(Bsp,BS_files,lomo_min,max_band,nkbz,nsppol,opt_cvk,ucvol,nomega,omega,eps_exc,dos_exc)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: lomo_min
  integer,intent(in) :: max_band
  integer,intent(in) :: nkbz
  integer,intent(in) :: nomega
  integer,intent(in) :: nsppol
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  real(dp),intent(in) :: ucvol
  real(dp),intent(out) :: dos_exc(nomega)
  complex(dpc),intent(out) :: eps_exc(nomega,BSp%nq)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(in) :: opt_cvk(lomo_min:max_band,lomo_min:max_band,nkbz,nsppol,BSp%nq)
 end subroutine exc_eps_coupling
end interface

interface
 subroutine exc_write_tensor(BSp,BS_files,what,tensor)
  use defs_basis
  use m_bs_defs
  implicit none
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  character(len=*),intent(in) :: what
  complex(dpc),intent(in) :: tensor(BSp%nomega,6)
 end subroutine exc_write_tensor
end interface

interface
 subroutine mdfs_ncwrite(ncid,Bsp,eps_exc,eps_rpanlf,eps_gwnlf)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: ncid
  type(excparam),intent(in) :: BSp
  complex(dpc),target,intent(in) :: eps_exc(BSp%nomega,BSp%nq)
  complex(dpc),target,intent(in) :: eps_gwnlf(BSp%nomega,BSp%nq)
  complex(dpc),target,intent(in) :: eps_rpanlf(BSp%nomega,BSp%nq)
 end subroutine mdfs_ncwrite
end interface

interface
 subroutine exc_haydock_driver(BSp,BS_files,Cryst,Kmesh,Hdr_bse,KS_BSt,QP_Bst,Wfd,Psps,Pawtab,Hur,&  
  &  Kmesh_dense, KS_BSt_dense, QP_BSt_dense, Wfd_dense, Vcp_dense, grid)
  use m_vcoul
  use m_wfs
  use m_bz_mesh
  use m_double_grid
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use m_paw_commutator
  use m_pawtab
  use defs_datatypes
  implicit none
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(hdr_type),intent(in) :: Hdr_bse
  type(ebands_t),intent(in) :: KS_BSt
  type(ebands_t),intent(in),optional :: KS_BSt_dense
  type(kmesh_t),intent(in) :: Kmesh
  type(kmesh_t),intent(in),optional :: Kmesh_dense
  type(pseudopotential_type),intent(in) :: Psps
  type(ebands_t),intent(in) :: QP_Bst
  type(ebands_t),intent(in),optional :: QP_Bst_dense
  type(vcoul_t),intent(in),optional :: Vcp_dense
  type(wfd_t),intent(inout) :: Wfd
  type(wfd_t),intent(inout),optional :: Wfd_dense
  type(double_grid_t),intent(in),optional :: grid
  type(hur_commutator),intent(in) :: Hur(Cryst%natom*Wfd%usepaw)
  type(pawtab_type),intent(in) :: Pawtab(Cryst%ntypat*Wfd%usepaw)
 end subroutine exc_haydock_driver
end interface

interface
 subroutine haydock_herm_interp(BSp,BS_files,Cryst,Hdr_bse,hsize,hsize_dense,my_t1,my_t2,hmat,nkets,kets,diag_coarse,diag_dense,&  
  &  grid,Wfd,Wfd_dense,Kmesh_coarse,Kmesh_dense,acoeffs,bcoeffs,ccoeffs,Vcp_dense,green,comm)
  use m_vcoul
  use m_wfs
  use m_bz_mesh
  use m_double_grid
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use defs_basis
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(in) :: hsize_dense
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: nkets
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(hdr_type),intent(in) :: Hdr_bse
  type(kmesh_t),intent(in) :: Kmesh_coarse
  type(kmesh_t),intent(in) :: Kmesh_dense
  type(vcoul_t),intent(in) :: Vcp_dense
  type(wfd_t),intent(inout) :: Wfd
  type(wfd_t),intent(inout) :: Wfd_dense
  type(double_grid_t),intent(in) :: grid
  complex(dpc),intent(in) :: acoeffs(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: bcoeffs(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: ccoeffs(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: diag_coarse(hsize,hsize)
  complex(dpc),intent(in) :: diag_dense(hsize_dense)
  complex(dp),intent(out) :: green(BSp%nomega,nkets)
  complex(dpc),intent(in) :: hmat(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: kets(hsize_dense,nkets)
 end subroutine haydock_herm_interp
end interface

interface
 subroutine haydock_herm_algo_interp(BSp,niter_done,niter_max,nomega,omega,tol_iter,check,hsize,hsize_dense,&  
  &  my_t1,my_t2,hmat,diag_dense,grid,factor,term_type,aa,bb,phi_nm1,phi_n,&  
  &  green,inn,is_converged,ntrans,nbnd_coarse,corresp,overlaps,interp_factors,indices,comm,hinterp)
  use defs_basis
  use m_bs_defs
  use m_double_grid
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(in) :: hsize_dense
  integer,intent(out) :: inn
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: nbnd_coarse
  integer,intent(in) :: niter_done
  integer,intent(in) :: niter_max
  integer,intent(in) :: nomega
  integer,intent(in) :: ntrans
  integer,intent(in) :: term_type
  type(excparam),intent(in) :: BSp
  complex(dpc),intent(in) :: factor
  type(double_grid_t),intent(in) :: grid
  logical,intent(out) :: is_converged
  real(dp),intent(in) :: tol_iter
  logical,intent(in) :: check(2)
  complex(dpc),intent(inout) :: aa(niter_max)
  real(dp),intent(inout) :: bb(niter_max)
  integer,intent(in) :: corresp(hsize,8)
  complex(dpc),intent(in) :: diag_dense(hsize_dense)
  complex(dpc),intent(out) :: green(nomega)
  complex(dpc),intent(in) :: hinterp(hsize_dense,hsize_dense)
  complex(dpc),intent(in) :: hmat(hsize,hsize,8)
  integer,intent(in) :: indices(BSp%nreh(1),grid%ndiv)
  real(dp),intent(in) :: interp_factors(BSp%nreh(1),8,grid%ndiv)
  complex(dpc),intent(in) :: omega(nomega)
  complex(gwpc),intent(in) :: overlaps(ntrans,nbnd_coarse,8)
  complex(dpc),intent(inout) :: phi_n(hsize_dense)
  complex(dpc),intent(inout) :: phi_nm1(hsize_dense)
 end subroutine haydock_herm_algo_interp
end interface

interface
 subroutine compute_overlaps(BSp,grid,Wfd,Wfd_dense,Cryst,Kmesh_coarse,Kmesh_dense,ntrans,nbnd_coarse,neighbour,hsize,&  
  &  corresp,overlaps)
  use m_wfs
  use m_bz_mesh
  use m_double_grid
  use m_bs_defs
  use m_crystal
  use defs_basis
  implicit none
  integer,intent(in) :: hsize
  integer,intent(in) :: nbnd_coarse
  integer,intent(in) :: ntrans
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(kmesh_t),intent(in) :: Kmesh_coarse
  type(kmesh_t),intent(in) :: Kmesh_dense
  type(wfd_t),intent(inout) :: Wfd
  type(wfd_t),intent(inout) :: Wfd_dense
  type(double_grid_t),intent(in) :: grid
  integer,intent(in) :: neighbour(3)
  integer,intent(out) :: corresp(hsize)
  complex(gwpc),intent(out) :: overlaps(ntrans,nbnd_coarse)
 end subroutine compute_overlaps
end interface

interface
 subroutine preprocess_tables(BSp,grid,interp_factors,indices)
  use defs_basis
  use m_bs_defs
  use m_double_grid
  implicit none
  type(excparam), intent(in) :: BSp
  type(double_grid_t),intent(in) :: grid
  integer,intent(out) :: indices(BSp%nreh(1),grid%ndiv)
  real(dp),intent(out) :: interp_factors(BSP%nreh(1),8,grid%ndiv)
 end subroutine preprocess_tables
end interface

interface
 subroutine compute_hinterp(BSp,hsize,hsize_dense,hmat,grid,ntrans,nbnd_coarse,corresp,overlaps,interp_factors,indices,&  
  &  acoeffs,bcoeffs,ccoeffs,Kmesh_dense,Vcp_dense,gmet,hinterp)
  use m_vcoul
  use defs_basis
  use m_bs_defs
  use m_bz_mesh
  use m_double_grid
  implicit none
  integer,intent(in) :: hsize
  integer,intent(in) :: hsize_dense
  integer,intent(in) :: nbnd_coarse
  integer,intent(in) :: ntrans
  type(excparam),intent(in) :: BSp
  type(kmesh_t),intent(in) :: Kmesh_dense
  type(vcoul_t),intent(in) :: Vcp_dense
  type(double_grid_t),intent(in) :: grid
  complex(dpc),intent(in) :: acoeffs(hsize,hsize,8)
  complex(dpc),intent(in) :: bcoeffs(hsize,hsize,8)
  complex(dpc),intent(in) :: ccoeffs(hsize,hsize,8)
  integer,intent(in) :: corresp(hsize,8)
  real(dp),intent(in) :: gmet(3,3)
  complex(dpc),intent(out) :: hinterp(hsize_dense,hsize_dense)
  complex(dpc),intent(in) :: hmat(hsize,hsize,8)
  integer,intent(in) :: indices(BSp%nreh(1),grid%ndiv)
  real(dp),intent(in) :: interp_factors(BSp%nreh(1),8,grid%ndiv)
  complex(gwpc),intent(in) :: overlaps(ntrans,nbnd_coarse,8)
 end subroutine compute_hinterp
end interface

interface
 subroutine haydock_interp_matmul(BSp,hsize,hsize_dense,hmat,diag_dense,phi,hphi,grid,&  
  &  ntrans,nbnd_coarse,corresp,overlaps, interp_factors, indices, hinterp)
  use defs_basis
  use m_bs_defs
  use m_double_grid
  implicit none
  integer,intent(in) :: hsize
  integer,intent(in) :: hsize_dense
  integer,intent(in) :: nbnd_coarse
  integer,intent(in) :: ntrans
  type(excparam),intent(in) :: BSp
  type(double_grid_t),intent(in) :: grid
  integer,intent(in) :: corresp(hsize,8)
  complex(dpc),intent(in) :: diag_dense(hsize_dense)
  complex(dpc),intent(in) :: hinterp(hsize_dense,hsize_dense)
  complex(dpc),intent(in) :: hmat(hsize,hsize,8)
  complex(dpc),intent(out) :: hphi(hsize_dense)
  integer,intent(in) :: indices(BSp%nreh(1),grid%ndiv)
  real(dp),intent(in) :: interp_factors(BSp%nreh(1),8,grid%ndiv)
  complex(gwpc),intent(in) :: overlaps(ntrans,nbnd_coarse,8)
  complex(dpc),intent(in) :: phi(hsize_dense)
 end subroutine haydock_interp_matmul
end interface

interface
 subroutine haydock_herm(BSp,BS_files,Cryst,Hdr_bse,hsize,my_t1,my_t2,hmat,nkets,kets,green,comm)
  use defs_basis
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: nkets
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(hdr_type),intent(in) :: Hdr_bse
  complex(dp),intent(out) :: green(BSp%nomega,nkets)
  complex(dpc),intent(in) :: hmat(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: kets(hsize,nkets)
 end subroutine haydock_herm
end interface

interface
 subroutine haydock_herm_algo(niter_done,niter_max,nomega,omega,tol_iter,check,hsize,my_t1,my_t2,hmat,&  
  &  factor,term_type,aa,bb,phi_nm1,phi_n,green,inn,is_converged,comm)
  use defs_basis
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(out) :: inn
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: niter_done
  integer,intent(in) :: niter_max
  integer,intent(in) :: nomega
  integer,intent(in) :: term_type
  complex(dpc),intent(in) :: factor
  logical,intent(out) :: is_converged
  real(dp),intent(in) :: tol_iter
  logical,intent(in) :: check(2)
  complex(dpc),intent(inout) :: aa(niter_max)
  real(dp),intent(inout) :: bb(niter_max)
  complex(dpc),intent(out) :: green(nomega)
  complex(dpc),intent(in) :: hmat(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(inout) :: phi_n(my_t2-my_t1+1)
  complex(dpc),intent(inout) :: phi_nm1(my_t2-my_t1+1)
 end subroutine haydock_herm_algo
end interface

interface
 subroutine haydock_restart(BSp,restart_file,ftype,iq_search,hsize,niter_file,aa_file,bb_file,phi_nm1_file,phi_n_file,comm)
  use defs_basis
  use m_bs_defs
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: ftype
  integer,intent(in) :: hsize
  integer,intent(in) :: iq_search
  integer,intent(out) :: niter_file
  type(excparam),intent(in) :: BSp
  character(len=*),intent(in) :: restart_file
  complex(dpc),pointer :: aa_file(:)
  real(dp),pointer :: bb_file(:)
  complex(dpc),pointer :: phi_n_file(:)
  complex(dpc),pointer :: phi_nm1_file(:)
 end subroutine haydock_restart
end interface

interface
 subroutine haydock_mdf_to_tensor(BSp,Cryst,eps,tensor_cart,tensor_red,ierr)
  use defs_basis
  use m_bs_defs
  use m_crystal
  implicit none
  integer,intent(out) :: ierr
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  complex(dpc),intent(in) :: eps(BSp%nomega,BSp%nq)
  complex(dpc),intent(out) :: tensor_cart(BSp%nomega,6)
  complex(dpc),intent(out) :: tensor_red(BSp%nomega,6)
 end subroutine haydock_mdf_to_tensor
end interface

interface
 subroutine haydock_psherm(BSp,BS_files,Cryst,Hdr_bse,hsize,my_t1,my_t2,hreso,hcoup,nkets,kets,green,comm)
  use defs_basis
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: nkets
  type(excfiles),intent(in) :: BS_files
  type(excparam),intent(in) :: BSp
  type(crystal_t),intent(in) :: Cryst
  type(hdr_type),intent(in) :: Hdr_bse
  complex(dp),intent(out) :: green(BSp%nomega,BSp%nq)
  complex(dpc),intent(in) :: hcoup(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: hreso(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: kets(hsize,nkets)
 end subroutine haydock_psherm
end interface

interface
 subroutine haydock_psherm_optalgo(niter_done,niter_tot,nomega,omega,tol_iter,check,hsize,my_t1,my_t2,hreso,hcoup,&  
  &  factor,term_type,aa,bb,cc,ket0,ket0_hbar_norm,phi_nm1,phi_n,phi_np1,green,inn,is_converged,comm)
  use defs_basis
  implicit none
  integer,intent(in) :: comm
  integer,intent(in) :: hsize
  integer,intent(out) :: inn
  integer,intent(in) :: my_t1
  integer,intent(in) :: my_t2
  integer,intent(in) :: niter_done
  integer,intent(in) :: niter_tot
  integer,intent(in) :: nomega
  integer,intent(in) :: term_type
  complex(dpc),intent(in) :: factor
  logical,intent(out) :: is_converged
  real(dp),intent(in) :: ket0_hbar_norm
  real(dp),intent(in) :: tol_iter
  logical,intent(in) :: check(2)
  complex(dpc),intent(inout) :: aa(niter_tot)
  real(dp),intent(inout) :: bb(niter_tot+1)
  complex(dpc),intent(inout) :: cc(niter_tot+1)
  complex(dpc),intent(out) :: green(nomega)
  complex(dpc),intent(in) :: hcoup(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: hreso(hsize,my_t1:my_t2)
  complex(dpc),intent(in) :: ket0(my_t2-my_t1+1)
  complex(dpc),intent(in) :: omega(nomega)
  complex(dpc),intent(inout) :: phi_n(my_t2-my_t1+1)
  complex(dpc),intent(inout) :: phi_nm1(my_t2-my_t1+1)
  complex(dpc),intent(inout) :: phi_np1(my_t2-my_t1+1)
 end subroutine haydock_psherm_optalgo
end interface

interface
 subroutine setup_bse(codvsn,acell,rprim,ngfftf,ngfft_osc,Dtset,Dtfil,BS_files,Psps,Pawtab,BSp,&  
  &  Cryst,Kmesh,Qmesh,KS_BSt,QP_bst,Hdr_wfk,Gsph_x,Gsph_c,Vcp,Hdr_bse,w_fname,comm,Wvl)
  use m_vcoul
  use m_pawtab
  use m_bz_mesh
  use defs_abitypes
  use m_bs_defs
  use m_gsphere
  use m_crystal
  use defs_basis
  use defs_datatypes
  use defs_wvltypes
  implicit none
  integer,intent(in) :: comm
  type(excfiles),intent(out) :: BS_files
  type(excparam),intent(inout) :: Bsp
  type(crystal_t),intent(out) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(inout) :: Dtset
  type(gsphere_t),intent(out) :: Gsph_c
  type(gsphere_t),intent(out) :: Gsph_x
  type(hdr_type),intent(out) :: Hdr_bse
  type(hdr_type),intent(out) :: Hdr_wfk
  type(ebands_t),intent(out) :: KS_BSt
  type(kmesh_t),intent(out) :: Kmesh
  type(pseudopotential_type),intent(in) :: Psps
  type(ebands_t),intent(out) :: QP_Bst
  type(kmesh_t),intent(out) :: Qmesh
  type(vcoul_t),intent(out) :: Vcp
  type(wvl_internal_type), intent(in) :: Wvl
  character(len=6),intent(in) :: codvsn
  character(len=fnlen),intent(out) :: w_fname
  integer,intent(out) :: ngfft_osc(18)
  integer,intent(in) :: ngfftf(18)
  type(pawtab_type),intent(in) :: Pawtab(Psps%ntypat*Dtset%usepaw)
  real(dp),intent(in) :: acell(3)
  real(dp),intent(in) :: rprim(3,3)
 end subroutine setup_bse
end interface

interface
 subroutine setup_bse_interp(Dtset,Dtfil,BSp,Cryst,Kmesh,&  
  &  Kmesh_dense,Qmesh_dense,KS_BSt_dense,QP_bst_dense,Vcp_dense,Hdr_wfk_dense,ngfftf,grid,comm)
  use m_vcoul
  use m_bz_mesh
  use m_double_grid
  use defs_abitypes
  use m_bs_defs
  use m_crystal
  use defs_datatypes
  implicit none
  integer,intent(in) :: comm
  type(excparam),intent(inout) :: Bsp
  type(crystal_t),intent(in) :: Cryst
  type(datafiles_type),intent(in) :: Dtfil
  type(dataset_type),intent(in) :: Dtset
  type(hdr_type),intent(out) :: Hdr_wfk_dense
  type(ebands_t),intent(out) :: KS_BSt_dense
  type(kmesh_t),intent(in) :: Kmesh
  type(kmesh_t),intent(out) :: Kmesh_dense
  type(ebands_t),intent(out) :: QP_Bst_dense
  type(kmesh_t),intent(out) :: Qmesh_dense
  type(vcoul_t),intent(out) :: Vcp_dense
  type(double_grid_t),intent(out) :: grid
  integer,intent(in) :: ngfftf(18)
 end subroutine setup_bse_interp
end interface

interface
 subroutine check_kramerskronig(n,o,eps)
  use defs_basis
  implicit none
  integer,intent(in) :: n
  complex(dpc),intent(in) :: eps(n)
  real(dp),intent(in) :: o(n)
 end subroutine check_kramerskronig
end interface

interface
 subroutine check_fsumrule(n,o,e2,omegaplasma)
  use defs_basis
  implicit none
  integer,intent(in) :: n
  real(dp),intent(in) :: omegaplasma
  real(dp),intent(in) :: e2(n)
  real(dp),intent(in) :: o(n)
 end subroutine check_fsumrule
end interface

end module interfaces_71_bse
!!***
