!{\src2tex{textfont=tt}}
!!****f* ABINIT/icmpk2
!! NAME
!! icmpk2
!!
!! FUNCTION
!! Compare two k-points.
!! Return 1 if they are the same within a RL vector,
!!        0 if they are different.
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! PARENTS
!!
!! INPUTS
!!  k1(3),k2(3)=two k points to be compared
!!
!! OUTPUT
!!  function icmpk2= (see function description above)
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

integer function icmpk2(k1,k2)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!arrays
 real(dp),intent(in) :: k1(3),k2(3)

!Local variables-------------------------------
!scalars
 real(dp) :: f,x

! *************************************************************************
!
!  Statement function definition
 f(x)=abs(x-nint(x))
!
 icmpk2=0
 if(f(k1(1)-k2(1))<1.0e-4) then
   if(f(k1(2)-k2(2))<1.0e-4) then
     if(f(k1(3)-k2(3))<1.0e-4) then
       icmpk2=1
     end if
   end if
 end if

 return
 end function icmpk2
!!***
