/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.spring.ServiceBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;

public class XFireClientInterceptor
implements MethodInterceptor,
InitializingBean {
    private XFireProxyFactory proxyFactory;
    private Object xFireProxy;
    private String serviceUrl;
    private ServiceBean service;
    private XFire xfire;

    public void afterPropertiesSet() throws MalformedURLException {
        this.prepare();
    }

    public void prepare() throws MalformedURLException {
        if (this.getXfire() == null) {
            throw new IllegalArgumentException("xFire is required");
        }
        if (this.getServiceUrl() == null) {
            throw new IllegalArgumentException("serviceUrl is required");
        }
        if (this.proxyFactory == null) {
            this.proxyFactory = new XFireProxyFactory(this.getXfire());
        }
        this.xFireProxy = this.createXFireProxy(this.proxyFactory);
    }

    protected Object createXFireProxy(XFireProxyFactory proxyFactory) throws MalformedURLException {
        return proxyFactory.create(this.getService().getXFireService(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.xFireProxy == null) {
            throw new IllegalStateException("XFireClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.xFireProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertBurlapAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new AspectException("Failed to invoke SOAP service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertBurlapAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to SOAP service at [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access SOAP service at [" + this.getServiceUrl() + "]", ex);
    }

    public void setProxyFactory(XFireProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public ServiceBean getService() {
        return this.service;
    }

    public void setService(ServiceBean serviceBean) {
        this.service = serviceBean;
    }

    public XFire getXfire() {
        return this.xfire;
    }

    public void setXfire(XFire fire) {
        this.xfire = fire;
    }
}

