/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.storage.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.storage.client.StorageEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StorageImpl {
    public static final String LOCAL_STORAGE = "localStorage";
    public static final String SESSION_STORAGE = "sessionStorage";
    protected static List<StorageEvent.Handler> storageEventHandlers;
    protected static JavaScriptObject jsHandler;

    protected static final void handleStorageEvent(StorageEvent event) {
        if (!StorageImpl.hasStorageEventHandlers()) {
            return;
        }
        GWT.UncaughtExceptionHandler ueh = GWT.getUncaughtExceptionHandler();
        for (StorageEvent.Handler handler : storageEventHandlers) {
            if (ueh != null) {
                try {
                    handler.onStorageChange(event);
                }
                catch (Throwable t) {
                    ueh.onUncaughtException(t);
                }
                continue;
            }
            handler.onStorageChange(event);
        }
    }

    protected static boolean hasStorageEventHandlers() {
        return storageEventHandlers != null && !storageEventHandlers.isEmpty();
    }

    protected StorageImpl() {
    }

    public HandlerRegistration addStorageEventHandler(final StorageEvent.Handler handler) {
        this.getStorageEventHandlers().add(handler);
        if (storageEventHandlers.size() == 1) {
            this.addStorageEventHandler0();
        }
        return new HandlerRegistration(){

            public void removeHandler() {
                StorageImpl.this.removeStorageEventHandler(handler);
            }
        };
    }

    public native void clear(String var1);

    public native String getItem(String var1, String var2);

    public native int getLength(String var1);

    public native String key(String var1, int var2);

    public native void removeItem(String var1, String var2);

    public void removeStorageEventHandler(StorageEvent.Handler handler) {
        this.getStorageEventHandlers().remove(handler);
        if (storageEventHandlers.isEmpty()) {
            this.removeStorageEventHandler0();
        }
    }

    public native void setItem(String var1, String var2, String var3);

    protected native void addStorageEventHandler0();

    protected List<StorageEvent.Handler> getStorageEventHandlers() {
        if (storageEventHandlers == null) {
            storageEventHandlers = new ArrayList<StorageEvent.Handler>();
        }
        return storageEventHandlers;
    }

    protected native Storage getStorageFromEvent(StorageEvent var1);

    protected native void removeStorageEventHandler0();
}

