/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.vocabulary;

import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class RDFS {
    public static final String uri = "http://www.w3.org/2000/01/rdf-schema#";
    public static final Resource Class = Init.Class();
    public static final Resource Datatype = Init.Datatype();
    public static final Resource Container = Init.Container();
    public static final Resource ContainerMembershipProperty = Init.ContainerMembershipProperty();
    public static final Resource Literal = Init.Literal();
    public static final Resource Resource = Init.Resource();
    public static final Property comment = Init.comment();
    public static final Property domain = Init.domain();
    public static final Property label = Init.label();
    public static final Property isDefinedBy = Init.isDefinedBy();
    public static final Property range = Init.range();
    public static final Property seeAlso = Init.seeAlso();
    public static final Property subClassOf = Init.subClassOf();
    public static final Property subPropertyOf = Init.subPropertyOf();
    public static final Property member = Init.member();

    protected static final Resource resource(String local) {
        return ResourceFactory.createResource(uri + local);
    }

    protected static final Property property(String local) {
        return ResourceFactory.createProperty(uri, local);
    }

    public static String getURI() {
        return uri;
    }

    public static class Nodes {
        public static final Node Class = Init.Class().asNode();
        public static final Node Datatype = Init.Datatype().asNode();
        public static final Node Container = Init.Container().asNode();
        public static final Node ContainerMembershipProperty = Init.ContainerMembershipProperty().asNode();
        public static final Node Literal = Init.Literal().asNode();
        public static final Node Resource = Init.Resource().asNode();
        public static final Node comment = Init.comment().asNode();
        public static final Node domain = Init.domain().asNode();
        public static final Node label = Init.label().asNode();
        public static final Node isDefinedBy = Init.isDefinedBy().asNode();
        public static final Node range = Init.range().asNode();
        public static final Node seeAlso = Init.seeAlso().asNode();
        public static final Node subClassOf = Init.subClassOf().asNode();
        public static final Node subPropertyOf = Init.subPropertyOf().asNode();
        public static final Node member = Init.member().asNode();
    }

    public static class Init {
        public static Resource Class() {
            return RDFS.resource("Class");
        }

        public static Resource Datatype() {
            return RDFS.resource("Datatype");
        }

        public static Resource Container() {
            return RDFS.resource("Container");
        }

        public static Resource ContainerMembershipProperty() {
            return RDFS.resource("ContainerMembershipProperty");
        }

        public static Resource Literal() {
            return RDFS.resource("Literal");
        }

        public static Resource Resource() {
            return RDFS.resource("Resource");
        }

        public static Property comment() {
            return RDFS.property("comment");
        }

        public static Property domain() {
            return RDFS.property("domain");
        }

        public static Property label() {
            return RDFS.property("label");
        }

        public static Property isDefinedBy() {
            return RDFS.property("isDefinedBy");
        }

        public static Property range() {
            return RDFS.property("range");
        }

        public static Property seeAlso() {
            return RDFS.property("seeAlso");
        }

        public static Property subClassOf() {
            return RDFS.property("subClassOf");
        }

        public static Property subPropertyOf() {
            return RDFS.property("subPropertyOf");
        }

        public static Property member() {
            return RDFS.property("member");
        }
    }
}

