.TH libinput "1" "" "libinput @LIBINPUT_VERSION@" "libinput Manual"
.SH NAME
libinput \- tool to interface with libinput
.SH SYNOPSIS
.B libinput [\-\-help|\-\-version] \fI<command>\fR \fI[<args>]\fR
.SH DESCRIPTION
.PP
libinput is a library to handle input devices and provides device
detection and input device event processing for most Wayland
compositors and the X.Org xf86-input-libinput driver.
.PP
The
.B "libinput"
tools are a set of tools to debug, interface with and analyze data for
libinput. These tools create libinput contexts separate from that of
the compositor/X server and cannot change settings in a running session.
See section
.B COMMANDS
for a list of available commands.
.PP
libinput's API documentation and details on features and various high-level
concepts are available online at
.I https://wayland.freedesktop.org/libinput/doc/latest/
.PP
The man page for the X.Org xf86-input-libinput driver is
.B libinput(4).
.SH OPTIONS
.TP 8
.B \-\-help
Print help and exit
.TP 8
.B \-\-version
Print the version and exit
.SH COMMANDS
.TP 8
.B libinput\-debug\-events(1)
Print all events as seen by libinput
.TP 8
.B libinput\-debug\-gui(1)
Show a GUI to visualize libinput's events
.TP 8
.B libinput\-list\-devices(1)
List all devices recognized by libinput
.TP 8
.B libinput\-measure(1)
Measure various properties of devices
.TP 8
.B libinput\-measure\-touch\-size(1)
Measure touch size and orientation
.TP 8
.B libinput\-measure\-touchpad\-tap(1)
Measure tap-to-click time
.TP 8
.B libinput\-measure\-touchpad\-pressure(1)
Measure touch pressure
.TP 8
.B libinput\-measure\-trackpoint\-range(1)
Measure the delta range of a trackpoint
.SH LIBINPUT
Part of the
.B libinput(1)
suite
.PP
.SH SEE ALSO
libinput(4)
.PP
libinput's online documentation
.I https://wayland.freedesktop.org/libinput/doc/latest/
