/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class GroupByIterator
implements GroupIterator {
    private SequenceIterator population;
    private Expression keyExpression;
    private Collator collator;
    private XPathContext keyContext;
    private Controller controller;
    private int position = 0;
    private ArrayList groups = new ArrayList();
    private ArrayList groupKeys = new ArrayList();
    private ArrayList initialItems = new ArrayList();

    public GroupByIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext, Collator collator) throws XPathException {
        this.population = sequenceIterator;
        this.keyExpression = expression;
        this.keyContext = xPathContext;
        this.controller = xPathContext.getController();
        this.collator = collator;
        this.buildIndexedGroups();
    }

    private void buildIndexedGroups() throws XPathException {
        Item item;
        HashMap hashMap = new HashMap();
        SequenceIterator sequenceIterator = this.controller.getCurrentIterator();
        this.controller.setCurrentIterator(this.population);
        XPathContext xPathContext = this.controller.newXPathContext();
        while ((item = this.population.next()) != null) {
            AtomicValue atomicValue;
            SequenceIterator sequenceIterator2 = this.keyExpression.iterate(xPathContext);
            boolean bl = true;
            while ((atomicValue = (AtomicValue)sequenceIterator2.next()) != null) {
                ArrayList arrayList;
                Object object = atomicValue;
                if (atomicValue instanceof StringValue && this.collator != null) {
                    object = this.collator.getCollationKey(atomicValue.getStringValue());
                }
                if ((arrayList = (ArrayList)hashMap.get(object)) == null) {
                    ArrayList<Item> arrayList2 = new ArrayList<Item>();
                    arrayList2.add(item);
                    this.groups.add(arrayList2);
                    this.groupKeys.add(atomicValue);
                    this.initialItems.add(item);
                    hashMap.put(object, arrayList2);
                } else if (bl) {
                    arrayList.add(item);
                } else if (arrayList.get(arrayList.size() - 1) != item) {
                    arrayList.add(item);
                }
                bl = false;
            }
        }
        this.controller.setCurrentIterator(sequenceIterator);
    }

    public AtomicValue getCurrentGroupingKey() {
        return (AtomicValue)this.groupKeys.get(this.position - 1);
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ArrayListIterator((ArrayList)this.groups.get(this.position - 1));
    }

    public Item next() throws XPathException {
        if (this.position < this.groups.size()) {
            ++this.position;
            return this.current();
        }
        return null;
    }

    public Item current() {
        return (Item)((ArrayList)this.groups.get(this.position - 1)).get(0);
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupByIterator(this.population, this.keyExpression, this.keyContext.newContext(), this.collator);
    }
}

