/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;

public class ArrayElementValue
extends ElementValue {
    public static final String ENTRY_NAME = "ArrayElement";
    private static final int INITIAL_LENGTH = 2;
    private ElementValue[] elementValueEntries;

    protected ArrayElementValue() {
        super(91);
    }

    public ElementValue[] getElementValueEntries() {
        return this.elementValueEntries;
    }

    public void setConstValueIndex(ElementValue[] elementValueArray) {
        this.elementValueEntries = elementValueArray;
    }

    protected int getSpecificLength() {
        int n = 2;
        for (int i = 0; i < this.elementValueEntries.length; ++i) {
            n += this.elementValueEntries[i].getLength();
        }
        return n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        int n = dataInput.readUnsignedShort();
        this.elementValueEntries = new ElementValue[n];
        for (int i = 0; i < this.elementValueEntries.length; ++i) {
            this.elementValueEntries[i] = ElementValue.create(dataInput, this.classFile);
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.elementValueEntries);
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.elementValueEntries[i].write(dataOutput);
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "ArrayElementValue with " + this.getLength(this.elementValueEntries) + " entries");
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }
}

