.TH xsane 1 "15 Jun 2002"
.IX xsane
.SH NAME
xsane - scanner frontend for SANE
.SH SYNOPSIS
.B xsane
.RB [ --version | -v ]
.RB [ --license | -l ]
.RB [ --device-settings
.IR file
.RB | -d
.IR file ]
.RB [ --viewer | -V ]
.RB [ --save | -s ]
.RB [ --copy | -c ]
.RB [ --fax | -f ]
.RB [ --mail | -m ]
.RB [ --no-mode-selection | -n ]
.RB [ --Fixed | -F ]
.RB [ --Resizable | -R ]
.RB [ --print-filenames | -p ]
.RB [ --force-filename
.IR name
.RB | -N
.IR name ]
.RB [ --display
.IR d ]
.RB [ --sync ]
.RI [ devicename ]
.SH DESCRIPTION
.B xsane
provides a graphical user-interface to control an image
acquisition device such as a flatbed scanner.  It allows
previewing and scanning individual images and can be invoked either
directly from the command-line or through The GIMP image manipulation
program.  In the former case,
.B xsane
acts as a stand-alone program that saves acquired images in a suitable
PNM format (PBM for black-and-white images, PGM for grayscale images,
and PPM for color images) or converts the image to JPEG, PNG, PS or TIFF.
In the latter case, the images are directly passed to The GIMP for further
processing.

.B xsane
accesses image acquisition devices through the SANE (Scanner Access
Now Easy) interface.  The list of available devices depends on
installed hardware and configuration.  When invoked without an
explicit devicename argument,
.B xsane
presents a dialog listing all known and available devices.  To access
an available device that is not known to the system, the devicename
must be specified explicitly. The format of devicename is
backendname:devicefile (eg: umax:/dev/sga).
.SH RUNNING UNDER THE GIMP
To run
.B xsane
under the
.BR gimp (1),
you should at first make sure that xsane is
compiled with gimp support by entering "xsane -v" on a shell.
If xsane is compiled with gimp support then simply set a
symbolic link from the xsane-binary to one of the
.BR gimp (1)
plug-ins directories.  For example, for gimp-1.0.x the command
.PP
.RS
ln -s @BINDIR@/xsane ~/.gimp/plug-ins/
.RE
.PP
for gimp 1.2.x the command:
.PP
.RS
ln -s @BINDIR@/xsane ~/.gimp-1.2/plug-ins/
.RE
.PP
and for gimp 2.0.x the command:
.PP
.RS
ln -s @BINDIR@/xsane ~/.gimp-2.0/plug-ins/
.RE
.PP
adds a symlink for the
.B xsane
binary to the user's plug-ins directory.  After creating this symlink,
.B xsane
will be queried by
.BR gimp (1)
the next time it's invoked.  From then on,
.B xsane
can be invoked through "Xtns->XSane->Device dialog..." (gimp-1.0.x) or through
"File->Acquire->XSane->Device dialog..." (gimp-1.2.x and 2.0.x) menu entry.

You'll also find that the "Xtns->XSane" or "File->Acquire->XSane" menu contains
short-cuts to the SANE devices that were available at the time the
.B xsane
was queried. 
Note that
.BR gimp (1)
caches these short-cuts in ~/.gimp/pluginrc.  Thus, when the list of
available devices changes (e.g., a new scanner is installed or the
device of the scanner has changed), then it is typically desirable
to rebuild this cache.  To do this, you can either
.BR touch (1)
the
.B xsane
binary (e.g., "touch @BINDIR@/xsane") or delete the plugin cache
(e.g., "rm ~/.gimp/pluginrc").  Either way, invoking
.BR gimp (1)
afterwards will cause the pluginrc to be rebuilt.
.PP
When
.B xsane
is started from the
.B  gimp
then it is not possible to add a devicename explicitly. You have to make the
devices known to the system by configuring
.B sane-dll, sane-net
and
.B saned.

.SH OPTIONS
.PP
If the
.B --version
or
.B -v
flag is given xsane prints a version information, some
information about gtk+ and gimp version it is compiled
against and lists the supported file formats, then it exits.
.PP
when the
.B --license
or
.B -l
flag is given xsane prints license information and exits.
.PP
The
.B --device-settings
or
.B -d
flag reads the next option as default filename
for device settings. The extension ".drc" must not
be included.
.PP
The
.B --viewer
or
.B -V
flag forces xsane to start in viewer mode.
.PP
The
.B --save
or
.B -s
flag forces xsane to start in save mode.
.PP
The
.B --copy
or
.B -c
flag forces xsane to start in copy mode.
.PP
The
.B --fax
or
.B -f
flag forces xsane to start in fax mode.
.PP
The
.B --mail
or
.B -m
flag forces xsane to start in mail mode.
.PP
The
.B --no-mode-selection
or
.B -n
flag disables the menu for xsane mode selection (viewer, save, copy, fax, mail).
.PP
If the
.B --Fixed
or
.B -F
flag is given then xsane uses a fixed, non resizable main window.
The flag overwrites the preferences value.
.PP
If the
.B --Resizable
or
.B -R
flag is given then xsane uses a scrolled and resizable main window.
The flag overwrites the preferences value.
.PP
If
.B --print-filenames
or
.B -p
flag is given then xsane prints the names of created files to the standard output.
.PP
When the flag
.B --force-filename
or
.B -N
is given then xsane reads the next option as default image filename. The name should be
of the format "name-001.ext". (or any other number instead of 001) that 001 part
will be used as a filename counter if xsane is so configured. Beware that the
number of digits must correspond to the configuration of xsane. The selection box
for filenames is disabled. This option normally should be used with the option
.B --no-mode-selection
and
.B --save.
.PP
The
.B --display
flag selects the X11 display used to present the graphical user-interface
(see
.BR X (1)
for details).
.PP
The
.B --sync
flag requests a synchronous connection with the X11 server.  This is for
debugging purposes only.
.SH ENVIRONMENT
.TP
.I SANE_DEFAULT_DEVICE
is used to preselect the device in the device dialog. This way you only
have to accept the device (<ENTER> or OK-Button).

.SH FILES
.TP
.I $HOME/.sane/xsane/xsane.rc
This files holds the user preferences.  Normally, this file should not
be manipulated directly.  Instead, the user should customize the
program through the "Preferences" menu.
.TP
.I $HOME/.sane/xsane/devicename.rc
For each device, there is one rc-file that holds the saved settings
for that particular device.  Normally, this file should not be
manipulated directly.  Instead, the user should use the
.B xsane
interface to select appropriate values and then save the device
settings using the "Preferences->Save Device Settings" menubar entry.
.TP
.I @SANEDATADIR@/xsane/xsane-style.rc
This system-wide file controls the aspects of the user-interface such
as colors and fonts.  It is a GTK style file and provides fine control
over the visual aspects of the user-interface.
.TP
.I $HOME/.sane/xsane/xsane-style.rc
This file serves the same purpose as the system-wide style file.  If
present, it takes precedence over the system wide style file.
.SH "SEE ALSO"
gimp(1), xscanimage(1), scanimage(1),
sane\-dll(5), sane\-net(5), saned(1), sane\-scsi(5), sane\-usb(5),
sane\-"backendname"(5)
.SH AUTHOR
Oliver Rauch <Oliver.Rauch@rauch-domain.de>
