/* Entry point for g-ir-scanner ... this program is used during build time
 * only. 
 *
 * 19/12/14
 * 	- quick hack
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <locale.h>

#include <vips/vips.h>
#include <girepository.h>

static char *main_option_introspect_dump = NULL;

static GOptionEntry main_option[] = {
	{ "introspect-dump", 'i', 0, 
		G_OPTION_ARG_STRING, &main_option_introspect_dump, 
		N_( "dump introspection data" ), NULL },
	{ NULL }
};

int
main( int argc, char *argv[] )
{
	GOptionContext *context;
	GOptionGroup *main_group;
	GError *error = NULL;

	if( VIPS_INIT( argv[0] ) )
	        vips_error_exit( "unable to start VIPS" );

	textdomain( GETTEXT_PACKAGE );
	setlocale( LC_ALL, "" );

        context = g_option_context_new( _( "- introspect" ) );
	main_group = g_option_group_new( NULL, NULL, NULL, NULL, NULL );
	g_option_group_add_entries( main_group, main_option );
	vips_add_option_entries( main_group ); 
	g_option_group_set_translation_domain( main_group, GETTEXT_PACKAGE );
	g_option_context_set_main_group( context, main_group );

	if( !g_option_context_parse( context, &argc, &argv, &error ) ) {
		if( error ) {
			fprintf( stderr, "%s\n", error->message );
			g_error_free( error );
		}

		vips_error_exit( "try \"%s --help\"", g_get_prgname() );
	}

	g_option_context_free( context );

#ifdef DEBUG
	/* For debugging it's handy to have a copy of the input file.
	 */
	if( main_option_introspect_dump ) { 
		char **args;
		char *cmd;

		args = g_strsplit( main_option_introspect_dump, ",", 2 );
		cmd = g_strdup_printf( "cp %s ~/functions.txt", args[0]);
		printf( "introspect: running '%s'\n", cmd );
		system( cmd );
		g_free( cmd );
	}
#endif /*DEBUG*/

	if( main_option_introspect_dump &&
		!g_irepository_dump( main_option_introspect_dump, &error ) ) {
		if( error ) {
			fprintf( stderr, "%s\n", error->message );
			g_error_free( error );
		}

		vips_error_exit( "unable to dump introspection" ); 
	}

	vips_shutdown();

	return( 0 );
}
