.TH sane\-coolscan2 5 "11 Jul 2008"  "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-coolscan2
.SH NAME
sane\-coolscan2 \- SANE backend for Nikon Coolscan film scanners
.SH DESCRIPTION
The
.B sane\-coolscan2
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Nikon Coolscan film scanners.  Some functions of this
backend should be considered
.B beta-quality
software. Most functions have been stable for a long time, but of
course new development can not and will not function properly from
the very first day. Please report any strange behaviour to the
maintainer of the backend.

.PP
At present, the following scanners are known to work with this backend:
.PP
.RS
.ft CR
.nf
Model:                       Connection Type
---------------------------  -------------------
LS-30 (Coolscan III)         SCSI
LS-2000                      SCSI
LS-40 ED (Coolscan IV)       USB
LS-4000 ED                   IEEE 1394
LS-8000 ED                   IEEE 1394
.fi
.ft R
.RE

Please send mail to the backend author (andras@users.sourceforge.net) to
report successes or failures.

.SH OPTIONS
The options the backend supports can either be selected through command line
options to programs like
.BR scanimage (1)
or through GUI elements in
.BR xscanimage (1)
or
.BR xsane (1).

Valid command line options and their syntax can be listed by using:
.PP
.RS
scanimage \-\-help \-d coolscan2:<interface>:<device>
.RE
.PP
where <interface> and <device> specify the device in question, as in the
configuration file (see next section). The
.B \-d
parameter and its argument
can be omitted to obtain information on the first scanner identified. Use
the command:
.PP
.RS
scanimage \-L
.RE
.PP
to list all devices recognized by your SANE installation.

The options should be fully described by the description or tooltips given by
frontend. Here is a description of some of the most important options, in the
syntax with which they must be supplied to
.BR scanimage (1):
.TP
.B \-\-frame <n>
This option specifies which frame to operate on, if a motorized film strip
feeder or APS adapter are used. The frame number
.I <n>
ranges from 1 to the number of frames available, which is sensed each time
the backend is initialized (usually each time you start the frontend).
.TP
.B \-\-subframe <x>
This option shifts the scan window by the specified amount (default
unit is mm).
.TP
.B \-\-infrared=yes/no
If set to "yes", the scanner will read the infrared channel, thus allowing
defect removal in software. The infrared image is read during a second scan,
with no options altered. The backend must not be restarted between the scans.
If you use
.BR scanimage (1),
perform a batch scan with
.B \-\-batch\-count=2
to obtain the IR information.
.TP
.B \-\-depth <n>
Here <n> can either be 8 or the maximum number of bits supported by the
scanner (10, 12, or 14). It specifies whether or not the scanner reduces
the scanned data to 8 bits before sending it to the backend. If 8 bits are
used, some information and thus image quality is lost, but the amount of data
is smaller compared to higher depths. Also, many imaging programs and image
formats cannot handle depths greater than 8 bits.
.TP
.B \-\-autofocus
Perform autofocus operation. Unless otherwise specified by the other options (
.B \-\-focus\-on\-centre
and friends), focusing is performed on the centre of the selected scan area.
.TP
.B \-\-ae\-wb
.TP
.B \-\-ae
Perform a pre-scan to calculate exposure values automatically.
.B \-\-ae\-wb
will maintain the white balance, while
.B \-\-ae
will adjust each channel separately.
.TP
.B \-\-exposure
Multiply all exposure times with this value. This allows exposure
correction without modifying white balance.
.TP
.B \-\-load
Load the next slide when using the slide loader
(applies only to the SF\-200 bulk feeder).
.TP
.B \-\-eject
Eject the film strip or mounted slide when using the slide loader.
.TP
.B \-\-reset
Reset scanner. The scanner will perform the same action as when power is
turned on: it will eject the film strip (with the SF\-200 bulk feeder)
and calibrate itself. Use this whenever the scanner refuses to load
a film strip properly, as a result of
which
.B \-\-eject
does not work.

.SH CONFIGURATION FILE
The configuration file
.I @CONFIGDIR@/coolscan2.conf
specifies the device(s)
that the backend will use. Owing to the nature of the supported connection
types SCSI, USB, and IEEE 1394, the default configuration file supplied with
the SANE distribution should work without being edited.

Each line in the configuration file is either of the following, where all
entries are case-sensitive:
.TP
.I blank or starting with a '#' character
These lines are ignored, thus '#' can be used to include comments.
.TP
.I containing only the word """auto"""
This instructs the backend to probe for a scanner by scanning the buses for
devices with known identifiers. This is the default action when no
configuration file is present.
.TP
.I a line of the form <interface>:<device>
Here <interface> can be one of "scsi" or "usb", and <device> is the device
file of the scanner. Note that IEEE 1394 devices are handled by the SBP-2
module in the kernel and appear to SANE as SCSI devices.

.SH FILES
.TP
.I @LIBDIR@/libsane\-coolscan2.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-coolscan2.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I @CONFIGDIR@/coolscan2.conf
Configuration file for this backend, read each time the backend is
initialized.

.SH ENVIRONMENT
.TP
.B SANE_DEBUG_COOLSCAN2
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH "SEE ALSO"
.BR sane\-scsi (5),
.BR sane\-usb (5),
.BR scanimage (1),
.BR xscanimage (1),
.BR xsane (1)

.SH BUGS
Currently, the SANE protocol does not allow automatically updating options
whenever the hardware changes. Thus the number of choices for the
.B \-\-frame
option will be fixed when the backend is initialized (usually when the user
runs the frontend). In particular, if there is no film strip in the
automatic film strip feeder when the backend is initialized, the
.B \-\-frame
option will not appear at all. Also, restarting the frontend after swapping film
adapters is strongly recommended.

Linux kernels prior to 2.4.19 had a patch that truncated INQUIRY data
from IEEE 1394 scanners to 36 bytes, discarding vital information
about the scanner. The IEEE 1394 models therefore only work with
2.4.19 or later.

No real bugs currently known, please report any to the backend maintainer
or the SANE developers' email list.

.SH AUTHORS
The backend is written and maintained by Andr\['a]s Major
.IR <andras@users.sourceforge.net> .
