# Contributing

For the best chance of having your changes merged, please:

* Fork the project.

* Make your feature addition or bug fix.

* Add tests for it. This is important so it is not accidentally broken in a future version.

* Commit, do not mess with rakefile, version, or history. (If you want to have your own version, that is fine but bump version in a commit by itself so it can be ignored when pulled).

* Send a pull request. Bonus points for topic branches.

If your proposed changes only affect documentation, include the following on a
new line in each of your commit messages:

```
[ci skip]
```

This will signal [Travis](https://travis-ci.org) that running the test suite is
not necessary for these changes.

# Reporting Bugs

If you are experiencing unexpected behavior and, after having read [omniauth](https://github.com/intridea/omniauth) and [omniauth-twitter](https://github.com/arunagw/omniauth-twitter)'s documentation, are convinced this behavior is a bug, please:

1. [Search](https://github.com/arunagw/omniauth-twitter/issues) existing issues.
2. Collect enough information to reproduce the issue:

  * omniauth-twitter version

  * Ruby version

  * Specific setup conditions

  * Description of expected behavior

  * Description of actual behavior
