#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>

int main(int argc, char ** argv)
{
  int res = 0;
  long handle;
  char * progname;
  int verbose = 0;

  progname = argv[0];
  if ((argc > 1) && (!strcmp("-v",argv[1])) )
    {
      verbose=1;
      argv++;
      argc--;
    }  
  if (argc >= 3)
    {
      handle=strtol(argv[1],0,10);
      if(verbose)
        {
          printf("%s: calling REG syscall with handle %li and\narg pointer %p (string '%s')\n",
                 progname, handle, argv[2], argv[2]);
        }
      res = rsbac_reg(handle, argv[2]);
      if(res<0)
        fprintf(stderr, "Error: %i, errno: %i\n", res, errno);
      else
        if(verbose)
          printf("%i syscalls until now\n", res);
      return res;
    }
  else
    {
      printf("%s (RSBAC)\n***\n", argv[0]);
      printf("Use: %s [-v] handle string\n", progname);
      printf("This program calls sys_rsbac_reg() with handle handle and parameter string\n");
      printf(" -v = verbose\n");
    }
  return (res);
}
