#include "rheolef.h"
using namespace rheolef;
using namespace std;

int main (int argc, char** argv) {
  field wh;
  cin >> wh;
  string option =  (wh.n_component() == 3) ? "vector" : "scalar";
  space Ph (wh.get_geo(), "P2", option);
  Ph.block("top");  Ph.block("bottom");
  if (wh.dimension() == 3) {
    Ph.block("back"); Ph.block("front");
  } else {
    Ph.block("left"); Ph.block("right");
  }
  form m (wh.get_space(), Ph, "mass");
  form c (Ph,  Ph, "grad_grad");
  field psih (Ph, 0.);
  ssk<Float> fact_c = ldlt(c.uu);
  psih.u = fact_c.solve (m.uu*wh.u + m.ub*wh.b - c.ub*psih.b);
  cout << catchmark("psi") << psih;
  return 0;
}

