# Announce: Rakudo Perl 6 compiler, Release #117 (2017.11)

On behalf of the Rakudo development team, I’m very happy to announce the
November 2017 release of Rakudo Perl 6 #117. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.11:
 + SPECIAL NOTES:
    + Main development branch changed from “nom” to “master” [f40babb8]
 + Fixes:
    + Fixed Lock.protect to no longer leak Proxies [be9e19ef]
    + Fixed R:I:JSON to handle recursive Exceptions [3cba6204]
    + Fixed .perl output of an empty Set/SetHash [af3624d4]
    + Made some attribute defaults throw NYI instead of silently ignoring
        [9f54bc98][0973b307][6dab5aad]
    + Fixed quote lang cache regression [ad16c6fb]
    + Improved stability by always setting up `$*PID` [a1866b7b]
    + Implemented hypered nodality for all methodcall variations [3c4041ea]
    + Fixed combinations with * endpoints [bdc73563]
    + Made Range.sum sensible for -∞/∞ endpoints [5eeb72a9][21efe96f]
    + Made multi sub(:@c is copy) { } work [be1e2879]
    + Ensured CLOSE phasers have correct outer chain [96557571]
    + Fixed segfault on Bag.new.pick(1) [fe1f8632]
    + Improved handling of %b spacing sprintf [b2fbf893]
    + Made .head and .tail only take WhateverCode [5a29a0ce]
    + Moved signal() handling to the timer worker queue [1bc9936a]
    + Fixed default Encoding::alternative-names [2f0da94c]
    + Various improvements to warnings and error reporting [142c1d65][fff43fd7]
        [c9360203][497e0582][ad7c97df][88d67516]
 + Additions:
    + Channel can now be closed with sub close() [91543fe3][ef84aafc]
    + my %h is (Set|SetHash|Bag|BagHash|Mix|MixHash) now DWIM [1949a2bc]
        [6ac2b15c][aab2b983][b6a4d5b5]
    + Implemented metamethod shorthand syntax [5c96d554]
    + Kernel.cpu-cores returning the number of CPU cores available [61af87bc]
    + Kernel.cpu-usage exposed basic CPU usage information [c4d373c5]
    + Telemetry module providing an easy interface to system state reporting
        [cbd4f212][273168d7][3e175c83][7f154fe2][3dfaa2ae][59a59be8][52440486]
        [b30916f3][b30916f3][f7d21b5d][ae1f0fda][f72ad227][4b4429cc][58249a52]
        [f51a3efc][8a0eb7fa][bc00894f][e95b02f1][ccbfaaa0][2f963b14][c1867ba1]
        [8e4d3248][0a809698][824a5dc2][dcf3e28c][0bdda086][a2ae00ed][86d541f4]
        [474feb09][5e7dfe52][3b4f0c6c][7144dc29][73e1faaa][cf1742dc][91e00e68]
        [96751ee8][7e00908c][d21c31e1][0dc4a0eb][c2baf95e][e1a1b8d8][b380230d]
        [fccc7515][1c2c7d84][2f12bea1][4ed91ed6][fea5612c][360eb228][9344d35d]
        [d5fc6cbb][3e4ef2e0][4d21ad67][0f2f0cd3][22939bc8][77142fdb][ab03b54c]
        [fc9e7241][948a3fa4][f8e1a5fa][17db03eb][14e2016c][2dcefa1c][345fbf5a]
        [b80d486c][3e4ccce9][86e9f44a][f87d8ef8][5f4b61b1][e5912337][de961b81]
        [d6f1077d][ba49b343][1aa83a78][06cbe9c2][246f4101][d6a3a7a1][88a9cb25]
        [9381ffbc]
 + Efficiency:
    + Made .sum on native num arrays 11x faster [b849622e]
    + Made INITTIME a bit faster [e00f705d]
    + Made interpolation of variables into regexes a bit faster [6bca84fa]
        [c93dc9e6][fa8bc549]
    + Made Buf ~ Blob about 7x faster, Blob ~ Blob 1.8x faster [8b47adad]
    + OS thread exhaustion is now handled more gracefully [fe799a98][57374490]
        [14fbb5e7][6d8ed287]
    + Other more general ThreadPoolScheduler improvements [e513f19d][6ac53e42]
        [2cd568f9][6bf58921][6de66df7][6aa150db][09e038cd][a7972a0c][260e4a3a]
        [a9b8854a][09492179][6959349e][697e4ecf][b386963a][5d0ccf73][bfcc43ec]
        [87e87202][92543962]
    + Minor IterationBuffer improvements [c15e80de]
 + Internal:
    + ThreadPoolScheduler now keeping internal statistics, e.g. for Telemetry
        [2c84f77e]
    + Thread now keeping internal statistics, e.g. for Telemetry [68b2891d]
        [77048b6a][cb4d8b66]
    + Changed how Int.new gets rid of mixins [6cb7ebfb]
    + Normalized proto bodies [0edd0cc9][102fbd51]
    + Set no_inline when the dispatcher is needed [c1df0b1b][0ff32c7f]
    + Various JIT-related changes [3bd756f5][0a029db6]
    + Repository cleanup [028b7d22][5baede59][825a8b0d][6ec6f1eb]
    + Various improvements for the JVM backend [ac738b98][b2725c12][4849c733]
        [d6cd0d2f][8b24bf5c][38f51db9][581edd58]


The following people contributed to this release:

Elizabeth Mattijsen, Alex Chen, Pawel Murias, Zoffix Znet,
Aleks-Daniel Jakimenko-Aleksejev, Christian Bartolomäus, Will "Coke" Coleda,
Jan-Olof Hendig, Samantha McVey, Daniel Green, Tom Browder, Jeremy Studer,
Jonathan Worthington, Stefan Seifert, Moritz Lenz, Nick Logan,
Jarkko Haapalainen, W4anD0eR96, Patrick Sebastian Zimmermann,
Timo Paulssen, Steve Mynott, holli-holzer, ZzZombo, Brian Duggan,
Wenzel P. P. Peppmeyer, Curt Tilmes, Ahmad M. Zawawi

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#118), is tentatively scheduled for 2017-12-16.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
