# Announce: Rakudo Perl 6 compiler, Release #114 (2017.08)

On behalf of the Rakudo development team, I’m very happy to announce the
August 2017 release of Rakudo Perl 6 #114. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.08:
 + Security:
    + Removed '.' and 'blib' from nqp's default module search paths [7e403724]
        [a331c804][1eeb9434]
 + Fixes:
    + Fixed IO::Path.new with 0 allomorph [45cd1a97]
    + Fixed erroneous closing of standard handles in DESTROY [0e578c4f]
    + Fixed handling of already existing .moarvm files during install [02667bd8]
    + Fixed --ll-exception [559c9255]
    + Fixed native callbacks called from other threads [b81597bd][1d941643]
    + Fixes concat with combining codepoints and repetitions [1f7fa683]
    + Fixed TODO test handling inside TODOed subtests [5b77a8aa]
    + Fixed formatting of X::Numeric::DivideByZero [3f99d1d0]
    + Fixed potential concat issue [3028466c]
    + Fixed null handling in List.join [9b5cce0a]
    + Fixed handling of default values in Array [12d7d5b4][2fb8c725]
        [0970ba33][ccaa0665]
    + Fixed error message for postcircumfix [ ] called with a type object [1a74a8c3]
    + Made .unique|repeated|squish return containers if applicable [51e59eeb]
    + Fixed string comparison issues [0564891e]
    + Fixed is-lazy of iterators created with R:I.FromIndexes [4db23064]
    + Fixed pull-one of iterators created with R:I.MonotonicIndexes [0c19f549]
    + Fixed compiler explosion with import statement [3e078d4d]
    + Fixed is default() trait on Attributes [a7d2ad1d][148ba7f2]
    + Made sure to stop socket reader on close [21359560]
    + Fixed missing tap closes in `whenever` [59f4123e]
    + Fixed missing tap closes in Supply [c59b9867]
    + Fixed potential memory leak of supply/react [5fcce673]
    + Fixed Mix.roll with fractional weights [a91ad2da]
    + Fixed reproducibility of RAKUDO_MODULE_DEBUG output [ec7bc25c]
    + Fixed Pair.WHICH [4f1322d0][c229022c]
    + Fixed ignoremark issues [7b81f0f9][a3b95749]
    + Fixed bad assumption about methods being closures [231cb3f5]
    + Stopped hllizing and sinking the result of .+, .* and .= method calls [2b8115f0]
    + Fixed native shaped array index to return l-value [61e1f4d5]
    + Fixed handling of test descriptions with new lines [9303a6e4]
    + Fixed wrongful escaping of `# SKIP` TAP instruction [eb529f14]
    + Fixed returned exit code when running a MAIN script with --help [fcf61f7b]
    + Various improvements to produced messages [9b31d1f5][998535ed]
        [6d3ba60c][365a1d08][cff51ea1]
 + Additions:
    + Added Buf subbuf-rw method [d7af4aeb]
    + Added ACCEPTS method to Map to compare Maps [45ca084e]
    + Treat :ver<...> like a version instead of a string [247fc649]
    + Improved Version smart match with different lengths [01dbd874]
    + Added new peer/socket host/port values in async sockets [76af17a8]
    + Added .Complex coercion method to Cool [c9de2184]
    + Added atomic operations (⚛) [9b1e252a][92707fac][c67d7dd5][ca8aafc1]
 + Build system:
    + Added --libdir option to Configure.pl [e4d65ac9]
    + Fixed quotes for windows [90a0f2e0]
    + Added 'install' test target on appveyor [9c0d40ab]
 + Efficiency:
    + Made `$s (-) $s (-) $s` on a 26 elem set about 1.5x faster [d7fcb314]
    + Made .Str and .perl 2x faster, .gist 1.4x faster (on a ^100 .Set) [5b6cd406]
    + Made .Str 30% faster, .perl 2x faster (on a ^100 .Bag) [21b9a720]
    + Made string concatenation more efficient [1f7fa683]
    + Made Mixy.roll up to 2x faster [d3f260c9][e2ca1ffa]
    + Made Baggy.roll up to 1.5 faster [e548b743]
    + Made Baggy.roll(N) about 1.5x faster [752a3265]
    + Made List.roll(*) about 1.5x faster [b147217e]
    + Made .unique(:as) 3% faster [a636fa8f]
    + Made .unique(:with) about 4x faster [47d9bd9b]
    + Made .unique(:with(&[===])) about 20% faster [26789cc7]
    + Made .unique(:as,:with) about 12x faster [acf9f90d]
    + Made .repeated(:with) about 4x faster [d9056207][c3851aee]
    + Made .repeated(:as,:with) about 12x faster [a3a3d1a9][32ce4afd]
    + Made .pairup about 1.5x faster [8f73d77b]
    + Made .codes 350% faster for short strings [3c6277c7][e051dd2d][4eff4919]
    + Various improvements made by using `is default` on attributes [08f705b9]
        [d0419a0f][9f5686ec][c8c5c712][40d5b27d][fb5db592][413b7116][fbdbe6fb]
    + Made Map eqv Map about 10% faster [15b2596e]
    + Decreased the cost of Supply block teardown [5d200f1e]
    + Saved 2 method calls per NativeCall call [aca4b941]
    + Speeded up NativeCall by replacing the subroutine code in setup [46ef1b5b][9a0afcbc]
    + Speeded up NativeCall subs by compiling specialized subroutine body [cd7dc4ce]
 + Internal:
    + Introduced Mixy!total-positive [f49c49bb][ccf6da9e]
    + Set debug_names of DefiniteHOW and CoercionHOW types [b22d189e][c040f1a6]
    + Simplified `infix:<(+)>(**@p)` and `infix:<(.)>(**@p)` [d82db18f][a0775e5e]
    + Ensured Scalar fetch can never return a NULL [2f5a6cd9]
    + Changed RAW-KEYS to create iterator early [710fa800]
    + Made sure Setty at least has a R:I:IterationSet type object [2dd5963c]
    + Made R:I:Mappy roles also take IterationSets [ab08bd04]
    + Made Setty.values use R:I.Mappy-values directly [250ae102]
    + Made R:I:Mappy* roles use a more abstract name for low-level hash [b7953d0d]
    + Retired R:Q:Quanty in favor of R:I:Mappy [d9055e80]
    + Introduced R:Q.RAW-VALUES-MAP [923c32e6]
    + Simplified the .Seq coercer [5d89cef9]
    + Changed Baggy to no longer use HLL hash internally [fb7ecb60]
    + Changed Supply implementation to use iteration, not recursion [ed87f998]
    + Added tests for native int as index to CArray [6cc858a0]
    + Simplified Hash creation for auto-vivification [84d052a0]
    + Various spesh, JIT, GC and other improvements [86cb1363][8bed4a67]
        [9658dd98][c1e41f9f][f590863e][4561c269][947376e2][1455a03b]
    + Introduced R:I.TwoValues [20e93d89][50f0508f]
    + Fixed some issues with R:I.OneValue [3ad33469]
    + Streamlined the standard Seq methods on Pair [30584dac]


The following people contributed to this release:

Elizabeth Mattijsen, Jonathan Worthington, Zoffix Znet, Samantha McVey,
Will "Coke" Coleda, Pawel Murias, Aleks-Daniel Jakimenko-Aleksejev,
Stefan Seifert, Jan-Olof Hendig, David Warring, Nick Logan, Larry Wall,
Daniel Green, Timo Paulssen, Lucas Buchala, Christopher Bottoms,
Brian Duggan, Altai-man, Lloyd Fournier, Will Coleda, Nic Q,
M. Faiz Zakwan Zamzuri, Sam Morrison, brian d foy, Vynce Montgomery,
Patrick R. Michaud, Oleksii Varianyk, JJ Merelo, Julien Simonet

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#115), is tentatively scheduled for 2017-09-16.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
