% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-null.R
\name{expect_null}
\alias{expect_null}
\title{Expectation: is an object \code{NULL}?}
\usage{
expect_null(object, info = NULL, label = NULL)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\description{
This is a special case because \code{NULL} is a singleton so it's possible
check for it either with \code{expect_equal(x, NULL)} or \code{expect_type(x, "NULL")}.
}
\examples{
x <- NULL
y <- 10

expect_null(x)
show_failure(expect_null(y))
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_error}}, \code{\link{expect_length}},
  \code{\link{expect_match}}, \code{\link{expect_message}},
  \code{\link{expect_named}}, \code{\link{expect_output}},
  \code{\link{expect_silent}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
