% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-messages.R
\name{expect_message}
\alias{expect_message}
\alias{expect_warning}
\title{Expectation: does code produce warnings or messages?}
\usage{
expect_message(object, regexp = NULL, ..., all = FALSE, info = NULL,
  label = NULL)

expect_warning(object, regexp = NULL, ..., all = FALSE, info = NULL,
  label = NULL)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{regexp}{Regular expression to test against.
\itemize{
\item A character vector giving a regular expression that must match the
message/warning
\item If \code{NULL}, the default, asserts that there should be a messsage/warning,
but doesn't test for a specific value.
\item If \code{NA}, asserts that there shouldn't be any messages or warnings.
}}

\item{...}{Arguments passed on to \code{expect_match}
\describe{
  \item{all}{Should all elements of actual value match \code{regexp} (TRUE),
or does only one need to match (FALSE)}
  \item{perl}{logical.  Should Perl-compatible regexps be used?}
  \item{fixed}{logical.  If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}
}}

\item{all}{Do messages/warnings need to match the \code{regexp} (\code{TRUE}), or
does only one need to match (\code{FALSE})?}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\value{
The first argument, invisibly.
}
\description{
Use \code{expect_message()} and \code{expect_warning()} to check if the messages or
warnings match the given regular expression.
}
\examples{
# Messages ------------------------------------------------------------------

f <- function(x) {
  if (x < 0) {
    message("*x* is already negative")
    return(x)
  }

  -x
}
expect_message(f(-1))
expect_message(f(-1), "already negative")
expect_message(f(1), NA)

# To test message and output, store results to a variable
expect_message(out <- f(-1), "already negative")
expect_equal(out, -1)

# You can use the arguments of grepl to control the matching
expect_message(f(-1), "*x*", fixed = TRUE)
expect_message(f(-1), "NEGATIVE", ignore.case = TRUE)

# Warnings ------------------------------------------------------------------
f <- function(x) {
  if (x < 0) {
    warning("*x* is already negative")
    return(x)
  }
  -x
}
expect_warning(f(-1))
expect_warning(f(-1), "already negative")
expect_warning(f(1), NA)

# To test message and output, store results to a variable
expect_warning(out <- f(-1), "already negative")
expect_equal(out, -1)

# You can use the arguments of grepl to control the matching
expect_warning(f(-1), "*x*", fixed = TRUE)
expect_warning(f(-1), "NEGATIVE", ignore.case = TRUE)

}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_error}}, \code{\link{expect_length}},
  \code{\link{expect_match}}, \code{\link{expect_named}},
  \code{\link{expect_null}}, \code{\link{expect_output}},
  \code{\link{expect_silent}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
