% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture-condition.R
\name{capture_condition}
\alias{capture_condition}
\alias{capture_error}
\alias{capture_expectation}
\alias{capture_message}
\alias{capture_warning}
\alias{capture_messages}
\alias{capture_warnings}
\title{Capture conditions, including messeages, warnings, expectations, and errors.}
\usage{
capture_condition(code)

capture_error(code)

capture_expectation(code)

capture_message(code)

capture_warning(code)

capture_messages(code)

capture_warnings(code)
}
\arguments{
\item{code}{Code to evaluate}
}
\value{
Singular functions (\code{capture_condition}, \code{capture_expectation} etc)
return a condition object. \code{capture_messages()} and \code{capture_warnings}
return a character vector of message text.
}
\description{
These functions allow you to capture the side-effects of a function call
including printed output, messages and warnings. They are used to evaluate
code for \code{\link[=expect_output]{expect_output()}}, \code{\link[=expect_message]{expect_message()}},
\code{\link[=expect_warning]{expect_warning()}}, and \code{\link[=expect_silent]{expect_silent()}}.
}
\examples{
f <- function() {
  message("First")
  warning("Second")
  message("Third")
}

capture_message(f())
capture_messages(f())

capture_warning(f())
capture_warnings(f())

# Condition will capture anything
capture_condition(f())
}
\keyword{internal}
