% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_semTools-deprecated.R, R/longInvariance.R,
%   R/measurementInvariance.R, R/measurementInvarianceCat.R, R/reliability.R
\name{semTools-deprecated}
\alias{semTools-deprecated}
\alias{longInvariance}
\alias{measurementInvariance}
\alias{measurementInvarianceCat}
\alias{reliability}
\alias{reliabilityL2}
\title{Deprecated functions in package \pkg{semTools}.}
\usage{
longInvariance(model, varList, auto = "all", constrainAuto = FALSE,
  fixed.x = TRUE, std.lv = FALSE, group = NULL, group.equal = "",
  group.partial = "", strict = FALSE, warn = TRUE, debug = FALSE,
  quiet = FALSE, fit.measures = "default", baseline.model = NULL,
  method = "satorra.bentler.2001", ...)

measurementInvariance(..., std.lv = FALSE, strict = FALSE, quiet = FALSE,
  fit.measures = "default", baseline.model = NULL,
  method = "satorra.bentler.2001")

measurementInvarianceCat(..., std.lv = FALSE, strict = FALSE,
  quiet = FALSE, fit.measures = "default", baseline.model = NULL,
  method = "default")

reliability(object, what = c("alpha", "omega", "omega2", "omega3", "ave"),
  return.total = FALSE, dropSingle = TRUE, omit.factors = character(0),
  omit.indicators = character(0), omit.imps = c("no.conv", "no.se"))

reliabilityL2(object, secondFactor, omit.imps = c("no.conv", "no.se"))
}
\description{
The functions listed below are deprecated and will be defunct
  in the near future. When possible, alternative functions with similar
  functionality are also mentioned. Help pages for deprecated functions are
  available at \code{help("semTools-deprecated")}.
}
\section{Previous measurement-invariance functions}{

The \code{measurementInvariance}, \code{measurementInvarianceCat}, and
\code{longInvariance} functions will no longer be supported. Instead, use
the \code{\link{measEq.syntax}} function, which is much more flexible and
supports a wider range of data (e.g., any mixture of \code{numeric} and
\code{ordered} indicators, any combination of multiple groups and repeated
measures, models fit to multiple imputations with \code{\link{runMI}}).
}

\section{Reliability}{

The original \code{reliability} function was suboptimally designed.
For example, AVE was returned, which is not a reliability index. Also,
alpha and several omega-type coefficients were returned, including the
original formula that was in appropriate for models with complex structure.
Some features could be controlled by the user for one but not both types of
index  For example, alpha for categorical indicators was returned on both
the observed and latent-response scales, but this was not an option for any
omega-type indices.  The omegas differed in terms of whether the observed or
model-implied covariance matrix was used in the denominator, but alpha was
only computed using the observed matrix.  These inconsistencies have been
resolved in the new \code{\link{compRelSEM}} function, which returns only
one reliability index (per factor, optionally total score) according to the
user's requested features, for which there is much more flexibility.
Average variance extracted is now available in a dedicated \code{\link{AVE}}
function.
}

\section{Higher-Order Reliability}{

Originally, composite reliability of a single higher-order factor was
estimated in a separate function: \code{reliabilityL2}.  It is now available
for multiple higher-order factors in the same model, and from the same
\code{\link{compRelSEM}} function that estimates reliability for first-order
factors, using the \code{higher=} argument to name higher-order factors in
the fitted model.
}

\keyword{internal}
