% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R, R/shortcut.R
\name{find_root_file}
\alias{find_root_file}
\alias{find_rstudio_root_file}
\alias{find_package_root_file}
\alias{find_remake_root_file}
\alias{find_testthat_root_file}
\title{File paths relative to the root of a directory hierarchy}
\usage{
find_root_file(..., criterion, path = ".")

find_rstudio_root_file(..., path = ".")

find_package_root_file(..., path = ".")

find_remake_root_file(..., path = ".")

find_testthat_root_file(..., path = ".")
}
\arguments{
\item{...}{\verb{[character]}\cr
Further path components passed to \code{\link[=file.path]{file.path()}}.
All arguments must be the same length or length one.}

\item{criterion}{\verb{[root_criterion]}\cr
A criterion, one of the predefined \link{criteria}
or created by \code{\link[=root_criterion]{root_criterion()}}.
Will be coerced using \code{\link[=as_root_criterion]{as_root_criterion()}}.}

\item{path}{\verb{[character(1)]}\cr
The start directory.}
}
\value{
The normalized path of the root as specified by the search criteria,
with the additional path components appended.
Throws an error if no root is found.
}
\description{
\code{find_root_file()} is a wrapper around \code{\link[=find_root]{find_root()}} that
appends an arbitrary number of path components to the root using
\code{\link[base:file.path]{base::file.path()}}.
}
\details{
This function operates on the notion of relative paths.
The \code{...} argument is expected to contain a path relative to the root.
If the first path component passed to \code{...} is already an absolute path,
the \code{criterion} and \code{path} arguments are ignored,
and \code{...} is forwarded to \code{\link[=file.path]{file.path()}}.
}
\examples{
\dontrun{
find_package_root_file("tests", "testthat.R")
has_file("DESCRIPTION", "^Package: ")$find_file
has_file("DESCRIPTION", "^Package: ")$make_fix_file(".")
}

}
\seealso{
\code{\link[=find_root]{find_root()}} \code{\link[utils:glob2rx]{utils::glob2rx()}} \code{\link[base:file.path]{base::file.path()}}
}
