% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R, R/shortcut.R
\name{find_root_file}
\alias{find_root_file}
\alias{find_rstudio_root_file}
\alias{find_package_root_file}
\alias{find_remake_root_file}
\alias{find_testthat_root_file}
\title{File paths relative to the root of a directory hierarchy}
\usage{
find_root_file(..., criterion, path = ".")

find_rstudio_root_file(..., path = ".")

find_package_root_file(..., path = ".")

find_remake_root_file(..., path = ".")

find_testthat_root_file(..., path = ".")
}
\arguments{
\item{...}{Further path components passed to \code{\link[=file.path]{file.path()}}}

\item{criterion}{A criterion, will be coerced using
\code{\link[=as.root_criterion]{as.root_criterion()}}}

\item{path}{The start directory}
}
\value{
The normalized path of the root as specified by the search criteria,
with the additional path components appended.
Throws an error if no root is found
}
\description{
Append an arbitrary number of path components to the root using
\code{\link[base:file.path]{base::file.path()}}.
}
\details{
The \code{find_root_file()} function is a simple wrapper around
\code{\link[=find_root]{find_root()}} that
appends an arbitrary number of path components to the root using
\code{\link[base:file.path]{base::file.path()}}.
}
\examples{
\dontrun{
find_package_root_file("tests", "testthat.R")
has_file("DESCRIPTION", "^Package: ")$find_file
has_file("DESCRIPTION", "^Package: ")$make_fix_file(".")
}

}
\seealso{
\code{\link[=find_root]{find_root()}} \code{\link[utils:glob2rx]{utils::glob2rx()}} \code{\link[base:file.path]{base::file.path()}}
}
