library(RcppHNSW)
context("cosine")

# numbers from:
# sklearn.metrics.pairwise.pairwise_distances(iris.data[5:15, 0:4], metric='cosine')
cosine_dist <- matrix(
  c(
    0.00000000e+00, 1.31438082e-04, 4.82989889e-04, 7.37108399e-04,
    9.93327490e-04, 1.13137420e-03, 1.83037974e-03, 2.62771618e-03,
    2.96597815e-03, 3.96576921e-03,
    0.00000000e+00, 1.31438082e-04, 6.80740485e-04, 9.09531789e-04,
    9.37478822e-04, 1.42561393e-03, 1.64781231e-03, 3.13244207e-03,
    3.31417857e-03, 3.42854570e-03,
    0.00000000e+00, 1.68829817e-04, 2.44071514e-04, 4.22170181e-04,
    6.82436803e-04, 7.37108399e-04, 8.12453964e-04, 8.19157018e-04,
    9.09531789e-04, 2.79805679e-03,
    0.00000000e+00, 2.44071514e-04, 3.83307015e-04, 5.49343444e-04,
    6.11410250e-04, 7.67102044e-04, 1.13137420e-03, 1.64781231e-03,
    1.88800695e-03, 4.37823658e-03,
    0.00000000e+00, 7.12567472e-05, 3.83307015e-04, 6.82436803e-04,
    1.10679571e-03, 1.47913902e-03, 2.03772306e-03, 2.62771618e-03,
    3.13244207e-03, 4.37554307e-03,
    0.00000000e+00, 1.68829817e-04, 2.65975293e-04, 7.67102044e-04,
    9.30752682e-04, 9.37478822e-04, 9.93327490e-04, 1.06615449e-03,
    1.10679571e-03, 1.60367331e-03,
    0.00000000e+00, 4.22170181e-04, 4.82989889e-04, 5.49343444e-04,
    6.80740485e-04, 9.30752682e-04, 1.47913902e-03, 1.84981749e-03,
    1.94708563e-03, 4.77142498e-03,
    0.00000000e+00, 7.12567472e-05, 6.11410250e-04, 8.12453964e-04,
    1.06615449e-03, 1.85080111e-03, 1.94708563e-03, 2.96597815e-03,
    3.42854570e-03, 3.75133220e-03,
    0.00000000e+00, 2.65975293e-04, 7.82778985e-04, 8.19157018e-04,
    1.42561393e-03, 1.83037974e-03, 1.84981749e-03, 1.85080111e-03,
    1.88800695e-03, 2.03772306e-03,
    0.00000000e+00, 7.82778985e-04, 1.60367331e-03, 2.79805679e-03,
    3.31417857e-03, 3.75133220e-03, 3.96576921e-03, 4.37554307e-03,
    4.37823658e-03, 4.77142498e-03
  ),
  nrow = 10, byrow = 10
)

res <- hnsw_knn(ui10, k = 10, distance = "cosine")
expect_equal(res$dist, cosine_dist, check.attributes = FALSE, tol = 1e-6)
