% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{write.pkgbib}
\alias{write.pkgbib}
\title{Generate a Bibtex File from Package Citations}
\usage{
write.pkgbib(
  entry = NULL,
  file = "Rpackages.bib",
  prefix = "",
  append = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{entry}{a \code{\link{bibentry}} object or a character vector of package
names. If \code{NULL}, then the list of all installed packages is used.}

\item{file}{output Bibtex file. It can be specified as a filename (as a single
character string), NULL for \code{stdout}, or a \code{link{connection}} object.
If \code{file} is a character string, an extension '.bib' is appended if not
already present.}

\item{prefix}{character string to prepend to the generated packages' Bibtex key.}

\item{append}{a logical that indicates that the Bibtex entries should be added
to the file. If \code{FALSE} (default), the file is overwritten.}

\item{verbose}{a logical to toggle verbosity. If \code{file=NULL}, verbosity
is forced off.}
}
\value{
the list of Bibtex objects -- invisibly.
}
\description{
Generates a Bibtex file from a list of packages or all the installed packages.
It is useful for adding relevant citations in Sweave documents.
}
\details{
Multiple citations are handled by adding a numeric suffix to the Bibtex key
(other than the first/main citation) as \code{"<pkgname>\%i"} (e.g. pkg, pkg2, pkg3).
}
\note{
The Old version of this function {write.bib} has now been integrated
by Romain Francois in the bibtex package.
}
\examples{

write.pkgbib(c('rbibutils', 'utils', 'tools'), file='references')
bibs <- rbibutils::readBib('references.bib', "UTF-8")
write.pkgbib(bibs, 'references2.bib')
bibs2 <- rbibutils::readBib('references.bib', "UTF-8")
identical(bibs, bibs2)
\dontshow{ stopifnot(identical(bibs, bibs2)) }

# write to stdout()
write.pkgbib(c('rbibutils', 'utils', 'tools'), file=NULL)

# clean up 
unlink(c('references.bib', 'references2.bib'))

}
\references{
\emph{Creating bibtex file of all installed packages?}
Achim Zeileis. R-help mailing list.
\url{https://stat.ethz.ch/pipermail/r-help/2009-December/415181.html}
}
\seealso{
\code{link{connection}}, \code{link{bibentry}}
}
\author{
Renaud Gaujoux, based on the function \code{Rpackages.bib}
from Achim Zeileis (see \emph{References}).
}
