% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{pageBreak}
\alias{pageBreak}
\title{add a page break to a worksheet}
\usage{
pageBreak(wb, sheet, i, type = "row")
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{i}{row or column number to insert page break.}

\item{type}{One of "row" or "column" for a row break or column break.}
}
\description{
insert page breaks into a worksheet
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")
writeData(wb, sheet = 1, x = iris)

pageBreak(wb, sheet = 1, i = 10, type = "row")
pageBreak(wb, sheet = 1, i = 20, type = "row")
pageBreak(wb, sheet = 1, i = 2, type = "column")

\dontrun{saveWorkbook(wb, "pageBreakExample.xlsx", TRUE)}
## In Excel: View tab -> Page Break Preview
}
\seealso{
\code{\link{addWorksheet}}
}
