#ifndef _OMX_SYMBOL_TABLE_
#define _OMX_SYMBOL_TABLE_ TRUE
typedef struct omxAlgebraTableEntry omxAlgebraTableEntry;
#include "omxMatrix.h"
#include "algebraOp.h"
struct omxAlgebraTableEntry {
	unsigned int number;
	const char opName[32];
	const char rName[32];
	int numArgs;
	algebra_op_t check;
	algebra_op_t calc;
};

void omxMatrixInvert(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixTranspose(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPower(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixMult(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixElementMult(omxMatrix** args, int numArgs, omxMatrix* result);
void omxKroneckerProd(omxMatrix** args, int numArgs, omxMatrix* result);
void omxQuadraticProd(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDivide(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixAdd(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixSubtract(omxMatrix** args, int numArgs, omxMatrix* result);
void omxUnaryMinus(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixHorizCatOp(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixVertCatOp(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixDeterminant(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixTraceOp(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixTotalSum(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixTotalProduct(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixMaximum(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixMinimum(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixAbsolute(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementCosine(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementCosh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementSine(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementSinh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementTangent(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementTanh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementExponent(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementNaturalLog(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementSquareRoot(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixExtract(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixVech(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixVechs(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixDiagonal(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixFromDiagonal(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMultivariateNormalIntegration(omxMatrix** args, int numArgs, omxMatrix* result);
void omxAllIntegrationNorms(omxMatrix** args, int numArgs, omxMatrix* result);
void omxSequenceGenerator(omxMatrix** args, int numArgs, omxMatrix* result);
void omxKroneckerPower(omxMatrix** args, int numArgs, omxMatrix* result);
void omxRowVectorize(omxMatrix** args, int numArgs, omxMatrix* result);
void omxColVectorize(omxMatrix** args, int numArgs, omxMatrix* result);
void omxRealEigenvectors(omxMatrix** args, int numArgs, omxMatrix* result);
void omxRealEigenvalues(omxMatrix** args, int numArgs, omxMatrix* result);
void omxImaginaryEigenvectors(omxMatrix** args, int numArgs, omxMatrix* result);
void omxImaginaryEigenvalues(omxMatrix** args, int numArgs, omxMatrix* result);
void omxUnaryNegation(omxMatrix** args, int numArgs, omxMatrix* result);
void omxSelectRows(omxMatrix** args, int numArgs, omxMatrix* result);
void omxSelectCols(omxMatrix** args, int numArgs, omxMatrix* result);
void omxSelectRowsAndCols(omxMatrix** args, int numArgs, omxMatrix* result);
void omxMatrixArithmeticMean(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBinaryGreaterThan(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBinaryLessThan(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBinaryAnd(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBinaryOr(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBinaryApproxEquals(omxMatrix** args, int numArgs, omxMatrix* result);
void omxExponential(omxMatrix** args, int numArgs, omxMatrix* result);
void omxExponential(omxMatrix** args, int numArgs, omxMatrix* result);
void omxCholesky(omxMatrix** args, int numArgs, omxMatrix* result);
void omxCovToCor(omxMatrix** args, int numArgs, omxMatrix* result);
void omxVechToMatrix(omxMatrix** args, int numArgs, omxMatrix* result);
void omxVechsToMatrix(omxMatrix** args, int numArgs, omxMatrix* result);
void mxMatrixLog(omxMatrix** args, int numArgs, omxMatrix* result);
void omxBroadcast(omxMatrix** args, int numArgs, omxMatrix* result);
void omxExponential(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPtoZ(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementLgamma(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementArcSine(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementArcCosine(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementArcTangent(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementAsinh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementAcosh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementAtanh(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementLgamma1p(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementLogPtoZ(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDbeta(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPbeta(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementBesselI(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementBesselJ(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementBesselK(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementBesselY(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDpois(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPpois(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDnbinom(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPnbinom(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDchisq(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPchisq(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDbinom(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPbinom(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementDcauchy(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementPcauchy(omxMatrix** args, int numArgs, omxMatrix* result);
void omxRowSums(omxMatrix** args, int numArgs, omxMatrix* result);
void omxColSums(omxMatrix** args, int numArgs, omxMatrix* result);
void evaluateOnGrid(omxMatrix** args, int numArgs, omxMatrix* result);
void omxElementRobustLog(omxMatrix** args, int numArgs, omxMatrix* result);
void pearsonSelCov(omxMatrix** args, int numArgs, omxMatrix* result);
void pearsonSelMean(omxMatrix** args, int numArgs, omxMatrix* result);
void MoorePenroseInvert(omxMatrix** args, int numArgs, omxMatrix* result);
extern const omxAlgebraTableEntry omxAlgebraSymbolTable[];
#endif
