% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{fit_with}
\alias{fit_with}
\title{Fit a list of formulas}
\usage{
fit_with(data, .f, .formulas, ...)
}
\arguments{
\item{data}{A dataset used to fit the models.}

\item{.f}{A fitting function such as \code{\link[stats:lm]{stats::lm()}},
\code{\link[lme4:lmer]{lme4::lmer()}} or \code{\link[rstanarm:stan_glmer]{rstanarm::stan_glmer()}}.}

\item{.formulas}{A list of formulas specifying a model.}

\item{...}{Additional arguments passed on to \code{.f}}
}
\description{
\code{fit_with()} is a pipe-friendly tool that applies a list of
formulas to a fitting function such as \code{\link[stats:lm]{stats::lm()}}.
The list of formulas is typically created with \code{\link[=formulas]{formulas()}}.
}
\details{
Assumes that \code{.f} takes the formula either as first argument
or as second argument if the first argument is \code{data}.  Most
fitting functions should fit these requirements.
}
\examples{
# fit_with() is typically used with formulas().
disp_fits <- mtcars \%>\% fit_with(lm, formulas(~disp,
  additive = ~drat + cyl,
  interaction = ~drat * cyl,
  full = add_predictors(interaction, ~am, ~vs)
))

# The list of fitted models is named after the names of the list of
# formulas:
disp_fits$full

# Additional arguments are passed on to .f
mtcars \%>\% fit_with(glm, list(am ~ disp), family = binomial)
}
\seealso{
\code{\link[=formulas]{formulas()}}
}
