% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_operators.R
\name{getTaskFormula}
\alias{getTaskFormula}
\title{Get formula of a task.}
\usage{
getTaskFormula(
  x,
  target = getTaskTargetNames(x),
  explicit.features = FALSE,
  env = parent.frame()
)
}
\arguments{
\item{x}{(\link{Task} | \link{TaskDesc})\cr
Task or its description object.}

\item{target}{(\code{character(1)})\cr
Left hand side of the formula.
Default is defined by task \code{x}.}

\item{explicit.features}{(\code{logical(1)})\cr
Should the features (right hand side of the formula) be explicitly listed?
Default is \code{FALSE}, i.e., they will be represented as \code{"."}.}

\item{env}{(\link{environment})\cr
Environment of the formula.
Default is \code{parent.frame()}.}
}
\value{
(\link{formula}).
}
\description{
This is usually simply \verb{<target> ~ }.
For multilabel it is \verb{<target_1> + ... + <target_k> ~}.
}
\seealso{
Other task: 
\code{\link{getTaskClassLevels}()},
\code{\link{getTaskCosts}()},
\code{\link{getTaskData}()},
\code{\link{getTaskDesc}()},
\code{\link{getTaskFeatureNames}()},
\code{\link{getTaskId}()},
\code{\link{getTaskNFeats}()},
\code{\link{getTaskSize}()},
\code{\link{getTaskTargetNames}()},
\code{\link{getTaskTargets}()},
\code{\link{getTaskType}()},
\code{\link{subsetTask}()}
}
\concept{task}
