% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make_kautz_graph}
\alias{make_kautz_graph}
\alias{graph.kautz}
\alias{kautz_graph}
\title{Kautz graphs}
\usage{
make_kautz_graph(m, n)

kautz_graph(...)
}
\arguments{
\item{m}{Integer scalar, the size of the alphabet. See details below.}

\item{n}{Integer scalar, the length of the labels. See details below.}

\item{...}{Passed to \code{make_kautz_graph}.}
}
\value{
A graph object.
}
\description{
Kautz graphs are labeled graphs representing the overlap of strings.
}
\details{
A Kautz graph is a labeled graph, vertices are labeled by strings of length
\code{n+1} above an alphabet with \code{m+1} letters, with the restriction
that every two consecutive letters in the string must be different. There is
a directed edge from a vertex \code{v} to another vertex \code{w} if it is
possible to transform the string of \code{v} into the string of \code{w} by
removing the first letter and appending a letter to it.

Kautz graphs have some interesting properties, see eg. Wikipedia for
details.
}
\examples{

make_line_graph(make_kautz_graph(2,1))
make_kautz_graph(2,2)

}
\seealso{
\code{\link{make_de_bruijn_graph}}, \code{\link{make_line_graph}}
}
\author{
Gabor Csardi <csardi.gabor@gmail.com>, the first version in R was
written by Vincent Matossian.
}
\keyword{graphs}
