% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlwidgets.R
\name{htmlwidgets-shiny}
\alias{htmlwidgets-shiny}
\alias{shinyWidgetOutput}
\alias{shinyRenderWidget}
\title{Shiny bindings for HTML widgets}
\usage{
shinyWidgetOutput(outputId, name, width, height, package = name,
  inline = FALSE, reportSize = FALSE)

shinyRenderWidget(expr, outputFunction, env, quoted)
}
\arguments{
\item{outputId}{output variable to read from}

\item{name}{Name of widget to create output binding for}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{package}{Package containing widget (defaults to \code{name})}

\item{inline}{use an inline (\code{span()}) or block container (\code{div()})
for the output}

\item{reportSize}{Should the widget's container size be reported in the
shiny session's client data?}

\item{expr}{An expression that generates an HTML widget (or a
\href{https://rstudio.github.io/promises/}{promise} of an HTML widget).}

\item{outputFunction}{Shiny output function corresponding to this render
function.}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the widget
  within Shiny applications.
}
\description{
Helpers to create output and render functions for using HTML widgets within
Shiny applications and interactive Rmd documents.
}
\details{
These functions are delegated to from within your widgets own shiny
  output and render functions. The delegation is boilerplate and always works
  the same for all widgets (see example below).
}
\examples{
# shiny output binding for a widget named 'foo'
fooOutput <- function(outputId, width = "100\%", height = "400px") {
  htmlwidgets::shinyWidgetOutput(outputId, "foo", width, height)
}

# shiny render function for a widget named 'foo'
renderFoo <- function(expr, env = parent.frame(), quoted = FALSE) {
  if (!quoted) { expr <- substitute(expr) } # force quoted
  htmlwidgets::shinyRenderWidget(expr, fooOutput, env, quoted = TRUE)
}
}
