% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_linetype.R
\name{scale_edge_linetype}
\alias{scale_edge_linetype}
\alias{scale_edge_linetype_continuous}
\alias{scale_edge_linetype_discrete}
\alias{scale_edge_linetype_manual}
\alias{scale_edge_linetype_identity}
\title{Edge linetype scales}
\usage{
scale_edge_linetype(..., na.value = "blank")

scale_edge_linetype_continuous(...)

scale_edge_linetype_discrete(..., na.value = "blank")

scale_edge_linetype_manual(..., values)

scale_edge_linetype_identity(..., guide = "none")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:hue_pal]{scales::hue_pal()}}).}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{na.value}{The linetype to use for \code{NA} values.}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{guide}{Guide to use for this scale. Defaults to \code{"none"}.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new linetype scales for edge geoms equivalent to
the ones already defined by ggplot2. See
\code{\link[ggplot2:scale_linetype]{ggplot2::scale_linetype()}} for more information. The different
geoms will know whether to use edge scales or the standard scales so it is
not necessary to write \code{edge_linetype} in the call to the geom - just
use \code{linetype}.
}
\seealso{
Other scale_edge_*: 
\code{\link{scale_edge_alpha}()},
\code{\link{scale_edge_colour}},
\code{\link{scale_edge_fill}},
\code{\link{scale_edge_shape}()},
\code{\link{scale_edge_size}()},
\code{\link{scale_edge_width}()},
\code{\link{scale_label_size}()}
}
\concept{scale_edge_*}
