% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_unrooted.R
\name{layout_tbl_graph_unrooted}
\alias{layout_tbl_graph_unrooted}
\title{Create an unrooted layout using equal-angle or equal-daylight}
\usage{
layout_tbl_graph_unrooted(
  graph,
  daylight = TRUE,
  length = NULL,
  tolerance = 0.05,
  rotation_mod = 1,
  maxiter = 100,
  circular = FALSE
)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{daylight}{Should equal-daylight adjustments be made}

\item{length}{An expression evaluating to the branch length of each edge}

\item{tolerance}{The threshold for mean angular adjustment before terminating
the daylight adjustment}

\item{rotation_mod}{A modifier for the angular adjustment of each branch. Set
it below 1 to let the daylight adjustment progress more slowly}

\item{maxiter}{The maximum number of iterations in the the daylight
adjustment}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular}, \code{leaf} as well as
any information stored as node variables in the tbl_graph object.
}
\description{
When drawing unrooted trees the standard dendrogram layout is a bad fit as it
implicitly creates a visual root node. Instead it is possible to spread the
leafs out on the plane without putting any special emphasis on a particular
node using an unrooted layout. The standard algorithm is the equal angle
algorithm, but it can struggle with optimising the leaf distribution for
large trees trees with very uneven branch length. The equal daylight
algorithm modifies the output of the equal angle algorithm to better disperse
the leaves, at the cost of higher computational cost and the possibility of
edge crossings for very large unbalanced trees. For standard sized trees the
daylight algorithm is far superior and not too heavy so it is the default.
}
\note{
Unrooted is a layout intended for undirected trees, that is, graphs with no
cycles. If the provided graph does not fit this format an attempt to convert
it to such a format will be made.
}
\references{
Felsenstein, J. (2004) \emph{Drawing Trees}, in Inferring Phylogenies. Sinauer
Assoc., pp 573-584
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()}
}
\concept{layout_tbl_graph_*}
