% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarterly-year-quarter-day.R
\name{as_year_quarter_day}
\alias{as_year_quarter_day}
\title{Convert to year-quarter-day}
\usage{
as_year_quarter_day(x, ..., start = NULL)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to convert to year-quarter-day.}

\item{...}{These dots are for future extensions and must be empty.}

\item{start}{\verb{[integer(1) / NULL]}

The month to start the fiscal year in. 1 = January and 12 = December.

If \code{NULL}:
\itemize{
\item If \code{x} is a year-quarter-day, it will be returned as is.
\item Otherwise, a \code{start} of January will be used.
}}
}
\value{
A year-quarter-day vector.
}
\description{
\code{as_year_quarter_day()} converts a vector to the year-quarter-day
calendar. Time points, Dates, POSIXct, and other calendars can all be
converted to year-quarter-day.
}
\examples{
# From Date
as_year_quarter_day(as.Date("2019-01-01"))
as_year_quarter_day(as.Date("2019-01-01"), start = 3)

# From POSIXct, which assumes that the naive time is what should be converted
as_year_quarter_day(as.POSIXct("2019-01-01 02:30:30", "America/New_York"))

# From other calendars
tuesday <- 3
as_year_quarter_day(year_month_weekday(2019, 2, tuesday, 2))

# Converting between `start`s
x <- year_quarter_day(2019, 01, 01, start = 2)
x

# Default keeps the same start
as_year_quarter_day(x)

# But you can change it
as_year_quarter_day(x, start = 1)
}
