% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-limits.R
\name{cell_limits}
\alias{as.cell_limits}
\alias{as.cell_limits.NULL}
\alias{as.cell_limits.cell_limits}
\alias{as.cell_limits.character}
\alias{cell_limits}
\alias{dim.cell_limits}
\title{Create a cell_limits object}
\usage{
cell_limits(ul = c(NA_integer_, NA_integer_), lr = c(NA_integer_,
  NA_integer_), sheet = NA_character_)

\method{dim}{cell_limits}(x)

as.cell_limits(x, ...)

\method{as.cell_limits}{cell_limits}(x, ...)

\method{as.cell_limits}{NULL}(x, ...)

\method{as.cell_limits}{character}(x, fo = NULL, ...)
}
\arguments{
\item{ul}{vector identifying upper left cell of target rectangle}

\item{lr}{vector identifying lower right cell of target rectangle}

\item{sheet}{string containing worksheet name, optional}

\item{x}{input to convert into a \code{cell_limits} object}

\item{...}{further arguments passed to or from other methods}

\item{fo}{either \code{"R1C1"} (the default) or \code{"A1"} specifying the
cell reference format; in many contexts, it can be inferred and is optional}
}
\value{
a \code{cell_limits} object
}
\description{
A \code{cell_limits} object is a list with three components:
}
\details{
\itemize{
  \item \code{ul} vector specifying upper left cell of target rectangle, of
  the form \code{c(ROW_MIN, COL_MIN)}
  \item \code{lr} vector specifying lower right cell of target rectangle, of
  the form \code{c(ROW_MAX, COL_MAX)}
  \item \code{sheet} string specifying worksheet name, which may be
  \code{NA}, meaning it's unspecified
}

A value of \code{NA} in \code{ul} or \code{lr} means the corresponding limit
is left unspecified. Therefore a verbose way to specify no limits at all
would be \code{cell_limits(c(NA, NA), c(NA, NA))}. If the maximum row or
column is specified but the associated minimum is not, then the minimum is
set to 1.

When specified via character, cell references can be given in A1 or R1C1
notation and must be interpretable as absolute references. For A1, this means
either both row and column are annotated with a dollar sign \code{$} or
neither is. So, no mixed references, like \code{B$4}. For R1C1, this means no
square brackets, like \code{R[-3]C[3]}.
}
\examples{
cell_limits(c(1, 3), c(1, 5))
cell_limits(c(NA, 7), c(3, NA))
cell_limits(c(NA, 7))
cell_limits(lr = c(3, 7))

cell_limits(c(1, 3), c(1, 5), "Sheet1")
cell_limits(c(1, 3), c(1, 5), "Spaces are evil")

dim(as.cell_limits("A1:F10"))

as.cell_limits("A1")
as.cell_limits("$Q$24")
as.cell_limits("A1:D8")
as.cell_limits("R5C11")
as.cell_limits("R2C3:R6C9")
as.cell_limits("Sheet1!R2C3:R6C9")
as.cell_limits("'Spaces are evil'!R2C3:R6C9")

\dontrun{
## explicitly mixed A1 references won't work
as.cell_limits("A$2")
## mixed or relative R1C1 references won't work
as.cell_limits("RC[4]")
}
}

