#' Citation data between social work journals for the 1985-86 period
#'
#' This example consists of the citation data between social 
#' work journals for the 1985-86 period, collected and analyzed 
#' in Baker (1992) 
#' 
#' @docType data
#'
#' @usage data(baker)
#'
#'
#' @keywords datasets
#'
#' @references 
#' \enc{Baker, D. R.}{Baker, D. R.} (1992). A Structural Analysis of Social Work Journal Network: 1985-1986. Journal of Social Service Research, 15(3-4), 153-168. doi: 10.1300/J079v15n03_09
#'
#'
#' @examples
#' # data(baker)
#' # Transforming it to matrix format
#' # baker <- as.matrix(baker)
#' # putting zeros on the diagonal
#' # diag(baker) <- 0 
"baker"
