% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5F.R
\name{H5Fcreate}
\alias{H5Fcreate}
\title{Create an HDF5 file}
\usage{
H5Fcreate(
  name,
  flags = h5default("H5F_ACC"),
  fcpl = NULL,
  fapl = NULL,
  native = FALSE
)
}
\arguments{
\item{name}{The name of the HDF5 file to create.}

\item{flags}{See \code{h5const("H5F_ACC")} for possible arguments.}

\item{fcpl, fapl}{Object object of class \linkS4class{H5IdComponent}.  This should
representing a file creation property list and a file access property list
respectively. See \code{\link[=H5Pcreate]{H5Pcreate()}} or  \code{\link[=H5Pcopy]{H5Pcopy()}} to create objects of this
kind.  Leaving as \code{NULL} will use the default HDF5 settings which are often
sufficient.}

\item{native}{An object of class \code{logical}. If \code{TRUE}, array-like
objects are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability
between programming languages. A file written with \code{native = TRUE}
should also be read with \code{native = TRUE}.}
}
\description{
Create an HDF5 file
}
