% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5A.R
\name{H5Aopen}
\alias{H5Aopen}
\alias{H5Aopen_by_name}
\alias{H5Aopen_by_idx}
\title{Open an attribute for an HDF5 object}
\usage{
H5Aopen(h5obj, name)

H5Aopen_by_name(h5obj, objname = ".", name)

H5Aopen_by_idx(
  h5obj,
  n,
  objname = ".",
  index_type = h5default("H5_INDEX"),
  order = h5default("H5_ITER")
)
}
\arguments{
\item{h5obj}{An object of class \linkS4class{H5IdComponent} representing a H5 object
identifier (file, group, or dataset). See \code{\link[=H5Fcreate]{H5Fcreate()}}, \code{\link[=H5Fopen]{H5Fopen()}},
\code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}}, \code{\link[=H5Dcreate]{H5Dcreate()}}, or \code{\link[=H5Dopen]{H5Dopen()}} to create an object of this kind.}

\item{name}{The name of the attribute (character).}

\item{objname}{The name of the object the attribute belongs to.}

\item{n}{Opens attribute number \code{n} in the given order and index. Indexing is C-style, base-0,
so the first attribute is opened with \code{n=0}.}

\item{index_type}{See \code{h5const("H5_INDEX")} for possible arguments.}

\item{order}{See \code{h5const("H5_ITER")} for possible arguments.}
}
\value{
An object of class \linkS4class{H5IdComponent} representing a H5 attribute identifier.
}
\description{
Open an attribute for an HDF5 object
}
