import pytest

from netaddr import cidr_abbrev_to_verbose
from netaddr.strategy.ipv4 import expand_partial_address


def test_cidr_abbrev_to_verbose():
    octets = range(0, 256)

    cidrs = [cidr_abbrev_to_verbose(octet) for octet in octets]

    assert len(cidrs) == 256

    assert cidrs == [
        '0.0.0.0/8',
        '1.0.0.0/8',
        '2.0.0.0/8',
        '3.0.0.0/8',
        '4.0.0.0/8',
        '5.0.0.0/8',
        '6.0.0.0/8',
        '7.0.0.0/8',
        '8.0.0.0/8',
        '9.0.0.0/8',
        '10.0.0.0/8',
        '11.0.0.0/8',
        '12.0.0.0/8',
        '13.0.0.0/8',
        '14.0.0.0/8',
        '15.0.0.0/8',
        '16.0.0.0/8',
        '17.0.0.0/8',
        '18.0.0.0/8',
        '19.0.0.0/8',
        '20.0.0.0/8',
        '21.0.0.0/8',
        '22.0.0.0/8',
        '23.0.0.0/8',
        '24.0.0.0/8',
        '25.0.0.0/8',
        '26.0.0.0/8',
        '27.0.0.0/8',
        '28.0.0.0/8',
        '29.0.0.0/8',
        '30.0.0.0/8',
        '31.0.0.0/8',
        '32.0.0.0/8',
        '33.0.0.0/8',
        '34.0.0.0/8',
        '35.0.0.0/8',
        '36.0.0.0/8',
        '37.0.0.0/8',
        '38.0.0.0/8',
        '39.0.0.0/8',
        '40.0.0.0/8',
        '41.0.0.0/8',
        '42.0.0.0/8',
        '43.0.0.0/8',
        '44.0.0.0/8',
        '45.0.0.0/8',
        '46.0.0.0/8',
        '47.0.0.0/8',
        '48.0.0.0/8',
        '49.0.0.0/8',
        '50.0.0.0/8',
        '51.0.0.0/8',
        '52.0.0.0/8',
        '53.0.0.0/8',
        '54.0.0.0/8',
        '55.0.0.0/8',
        '56.0.0.0/8',
        '57.0.0.0/8',
        '58.0.0.0/8',
        '59.0.0.0/8',
        '60.0.0.0/8',
        '61.0.0.0/8',
        '62.0.0.0/8',
        '63.0.0.0/8',
        '64.0.0.0/8',
        '65.0.0.0/8',
        '66.0.0.0/8',
        '67.0.0.0/8',
        '68.0.0.0/8',
        '69.0.0.0/8',
        '70.0.0.0/8',
        '71.0.0.0/8',
        '72.0.0.0/8',
        '73.0.0.0/8',
        '74.0.0.0/8',
        '75.0.0.0/8',
        '76.0.0.0/8',
        '77.0.0.0/8',
        '78.0.0.0/8',
        '79.0.0.0/8',
        '80.0.0.0/8',
        '81.0.0.0/8',
        '82.0.0.0/8',
        '83.0.0.0/8',
        '84.0.0.0/8',
        '85.0.0.0/8',
        '86.0.0.0/8',
        '87.0.0.0/8',
        '88.0.0.0/8',
        '89.0.0.0/8',
        '90.0.0.0/8',
        '91.0.0.0/8',
        '92.0.0.0/8',
        '93.0.0.0/8',
        '94.0.0.0/8',
        '95.0.0.0/8',
        '96.0.0.0/8',
        '97.0.0.0/8',
        '98.0.0.0/8',
        '99.0.0.0/8',
        '100.0.0.0/8',
        '101.0.0.0/8',
        '102.0.0.0/8',
        '103.0.0.0/8',
        '104.0.0.0/8',
        '105.0.0.0/8',
        '106.0.0.0/8',
        '107.0.0.0/8',
        '108.0.0.0/8',
        '109.0.0.0/8',
        '110.0.0.0/8',
        '111.0.0.0/8',
        '112.0.0.0/8',
        '113.0.0.0/8',
        '114.0.0.0/8',
        '115.0.0.0/8',
        '116.0.0.0/8',
        '117.0.0.0/8',
        '118.0.0.0/8',
        '119.0.0.0/8',
        '120.0.0.0/8',
        '121.0.0.0/8',
        '122.0.0.0/8',
        '123.0.0.0/8',
        '124.0.0.0/8',
        '125.0.0.0/8',
        '126.0.0.0/8',
        '127.0.0.0/8',
        '128.0.0.0/16',
        '129.0.0.0/16',
        '130.0.0.0/16',
        '131.0.0.0/16',
        '132.0.0.0/16',
        '133.0.0.0/16',
        '134.0.0.0/16',
        '135.0.0.0/16',
        '136.0.0.0/16',
        '137.0.0.0/16',
        '138.0.0.0/16',
        '139.0.0.0/16',
        '140.0.0.0/16',
        '141.0.0.0/16',
        '142.0.0.0/16',
        '143.0.0.0/16',
        '144.0.0.0/16',
        '145.0.0.0/16',
        '146.0.0.0/16',
        '147.0.0.0/16',
        '148.0.0.0/16',
        '149.0.0.0/16',
        '150.0.0.0/16',
        '151.0.0.0/16',
        '152.0.0.0/16',
        '153.0.0.0/16',
        '154.0.0.0/16',
        '155.0.0.0/16',
        '156.0.0.0/16',
        '157.0.0.0/16',
        '158.0.0.0/16',
        '159.0.0.0/16',
        '160.0.0.0/16',
        '161.0.0.0/16',
        '162.0.0.0/16',
        '163.0.0.0/16',
        '164.0.0.0/16',
        '165.0.0.0/16',
        '166.0.0.0/16',
        '167.0.0.0/16',
        '168.0.0.0/16',
        '169.0.0.0/16',
        '170.0.0.0/16',
        '171.0.0.0/16',
        '172.0.0.0/16',
        '173.0.0.0/16',
        '174.0.0.0/16',
        '175.0.0.0/16',
        '176.0.0.0/16',
        '177.0.0.0/16',
        '178.0.0.0/16',
        '179.0.0.0/16',
        '180.0.0.0/16',
        '181.0.0.0/16',
        '182.0.0.0/16',
        '183.0.0.0/16',
        '184.0.0.0/16',
        '185.0.0.0/16',
        '186.0.0.0/16',
        '187.0.0.0/16',
        '188.0.0.0/16',
        '189.0.0.0/16',
        '190.0.0.0/16',
        '191.0.0.0/16',
        '192.0.0.0/24',
        '193.0.0.0/24',
        '194.0.0.0/24',
        '195.0.0.0/24',
        '196.0.0.0/24',
        '197.0.0.0/24',
        '198.0.0.0/24',
        '199.0.0.0/24',
        '200.0.0.0/24',
        '201.0.0.0/24',
        '202.0.0.0/24',
        '203.0.0.0/24',
        '204.0.0.0/24',
        '205.0.0.0/24',
        '206.0.0.0/24',
        '207.0.0.0/24',
        '208.0.0.0/24',
        '209.0.0.0/24',
        '210.0.0.0/24',
        '211.0.0.0/24',
        '212.0.0.0/24',
        '213.0.0.0/24',
        '214.0.0.0/24',
        '215.0.0.0/24',
        '216.0.0.0/24',
        '217.0.0.0/24',
        '218.0.0.0/24',
        '219.0.0.0/24',
        '220.0.0.0/24',
        '221.0.0.0/24',
        '222.0.0.0/24',
        '223.0.0.0/24',
        '224.0.0.0/4',
        '225.0.0.0/4',
        '226.0.0.0/4',
        '227.0.0.0/4',
        '228.0.0.0/4',
        '229.0.0.0/4',
        '230.0.0.0/4',
        '231.0.0.0/4',
        '232.0.0.0/4',
        '233.0.0.0/4',
        '234.0.0.0/4',
        '235.0.0.0/4',
        '236.0.0.0/4',
        '237.0.0.0/4',
        '238.0.0.0/4',
        '239.0.0.0/4',
        '240.0.0.0/32',
        '241.0.0.0/32',
        '242.0.0.0/32',
        '243.0.0.0/32',
        '244.0.0.0/32',
        '245.0.0.0/32',
        '246.0.0.0/32',
        '247.0.0.0/32',
        '248.0.0.0/32',
        '249.0.0.0/32',
        '250.0.0.0/32',
        '251.0.0.0/32',
        '252.0.0.0/32',
        '253.0.0.0/32',
        '254.0.0.0/32',
        '255.0.0.0/32',
    ]


def test_cidr_abbrev_to_verbose_invalid_prefixlen():
    assert cidr_abbrev_to_verbose('192.0.2.0/33') == '192.0.2.0/33'


def test_expand_partial_address():
    assert expand_partial_address('10') == '10.0.0.0'
    assert expand_partial_address('10.1') == '10.1.0.0'
    assert expand_partial_address('192.168.1') == '192.168.1.0'
